/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph.viewer.model;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.boxed_economy.components.datapresentation.graph.model.GraphModel;
import org.boxed_economy.components.datapresentation.graph.model.PointList;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GAxis;

public class GDataSet {
    private transient GraphModel model;
    private Color color = Color.black;
    private GAxis axisX = new GAxis();
    private GAxis axisY = new GAxis();
    private GDataSet dependentX;
    private GDataSet dependentY;
    private PointList scaledPoints;

    public GDataSet(GraphModel model) {
        this.model = model;
        this.axisX.setModel(model.getAxisX());
        this.axisY.setModel(model.getAxisY());
    }

    public GraphModel getModel() {
        return this.model;
    }

    public void setModel(GraphModel model) {
        this.model = model;
    }

    public GAxis getAxisX() {
        if (this.dependentX != null && this.dependentX != this) {
            return this.dependentX.getAxisX();
        }
        return this.axisX;
    }

    public GAxis getAxisY() {
        if (this.dependentY != null && this.dependentY != this) {
            return this.dependentY.getAxisY();
        }
        return this.axisY;
    }

    public GDataSet getDependentX() {
        return this.dependentX;
    }

    public GDataSet getDependentY() {
        return this.dependentY;
    }

    public List getDependentXList() {
        ArrayList<GDataSet> list = new ArrayList<GDataSet>();
        list.add(this);
        GDataSet data = this;
        while (data.getDependentX() != this && data.getDependentX() != null) {
            list.add(data.getDependentX());
            data = data.getDependentX();
        }
        return list;
    }

    public List getDependentYList() {
        ArrayList<GDataSet> list = new ArrayList<GDataSet>();
        list.add(this);
        GDataSet data = this;
        while (data.getDependentY() != this && data.getDependentY() != null) {
            list.add(data.getDependentY());
            data = data.getDependentY();
        }
        return list;
    }

    public void setDependentX(GDataSet set) {
        this.dependentX = set;
    }

    public void setDependentY(GDataSet set) {
        this.dependentY = set;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void update() {
        this.createPointsCash();
    }

    private void createPointsCash() {
        this.scaledPoints = this.model.getPoints();
        double sx = this.getAxisX().getScale().getValue();
        double sy = this.getAxisY().getScale().getValue();
        this.scaledPoints.scale(sx, sy);
    }

    public PointList getScaledPoints() {
        if (this.scaledPoints == null) {
            this.createPointsCash();
        }
        return new PointList(this.scaledPoints);
    }

    public String toString() {
        return this.model.getLabel();
    }
}

