/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph.viewer.model;

import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import jp.ac.keio.sfc.crew.collection.MultipleValueMap;
import org.boxed_economy.components.datapresentation.graph.model.GraphModel;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GAxis;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GDataSet;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GGraphContainer;

public class GGraph {
    public static final Color[] COLORS = new Color[]{Color.BLACK, Color.BLUE, Color.RED, Color.GREEN, Color.MAGENTA, Color.CYAN, Color.ORANGE, Color.PINK};
    private GGraphContainer container;
    private List dataSets = new ArrayList();
    private boolean followingUpX = false;
    private boolean autoScallingX = false;
    private boolean autoScallingY = false;
    private boolean showGridX = true;
    private boolean showGridY = true;

    public void addData(GraphModel model) {
        GDataSet data = new GDataSet(model);
        this.dataSets.add(data);
        data.setColor(this.getInitialColor(this.dataSets.indexOf(data)));
    }

    public void removeData(GDataSet dataSet) {
        this.dataSets.remove(dataSet);
    }

    public List getDataSets() {
        return new ArrayList(this.dataSets);
    }

    public List getAxisListX() {
        LinkedHashSet<GAxis> axises = new LinkedHashSet<GAxis>();
        Iterator i = this.dataSets.iterator();
        while (i.hasNext()) {
            GDataSet data = (GDataSet)i.next();
            axises.add(data.getAxisX());
        }
        return new ArrayList(axises);
    }

    public List getAxisListY() {
        LinkedHashSet<GAxis> axises = new LinkedHashSet<GAxis>();
        Iterator i = this.dataSets.iterator();
        while (i.hasNext()) {
            GDataSet data = (GDataSet)i.next();
            axises.add(data.getAxisY());
        }
        return new ArrayList(axises);
    }

    public void update() {
        this.updateDataSets();
    }

    public void autoScalling(Dimension canvasSize) {
        List datasets;
        GAxis axis;
        MultipleValueMap axisMapX = new MultipleValueMap();
        MultipleValueMap axisMapY = new MultipleValueMap();
        Iterator i = this.dataSets.iterator();
        while (i.hasNext()) {
            GDataSet data = (GDataSet)i.next();
            axisMapX.put(data.getAxisX(), data);
            axisMapY.put(data.getAxisY(), data);
        }
        i = axisMapX.getKeys().iterator();
        while (i.hasNext()) {
            axis = (GAxis)i.next();
            datasets = axisMapX.get(axis);
            this.autoScallingX(axis, datasets, canvasSize.width);
        }
        i = axisMapY.getKeys().iterator();
        while (i.hasNext()) {
            axis = (GAxis)i.next();
            datasets = axisMapY.get(axis);
            this.autoScallingY(axis, datasets, canvasSize.height);
        }
    }

    private void autoScallingX(GAxis axis, List datasets, double canvasW) {
        if (this.autoScallingX || axis.getScale().isAuto()) {
            double maxX = this.calcOriginalMaxX(datasets);
            double minX = this.calcOriginalMinX(datasets);
            double dataW = maxX - minX;
            double scale = canvasW / dataW;
            axis.getScale().setValue(scale);
        }
    }

    private void autoScallingY(GAxis axis, List datasets, double canvasH) {
        if (this.autoScallingY || axis.getScale().isAuto()) {
            double maxY = this.calcOriginalMaxY(datasets);
            double minY = this.calcOriginalMinY(datasets);
            double dataH = maxY - minY;
            double scale = canvasH / dataH;
            axis.getScale().setValue(scale);
        }
    }

    private void updateDataSets() {
        Iterator i = this.dataSets.iterator();
        while (i.hasNext()) {
            GDataSet dataset = (GDataSet)i.next();
            dataset.update();
        }
    }

    public Color getInitialColor(int i) {
        if (i < COLORS.length) {
            return COLORS[i];
        }
        return COLORS[0];
    }

    public GGraphContainer getContainer() {
        return this.container;
    }

    public void setContainer(GGraphContainer container) {
        this.container = container;
    }

    public boolean isAutoScallingX() {
        return this.autoScallingX;
    }

    public boolean isAutoScallingY() {
        return this.autoScallingY;
    }

    public boolean isFollowingUpX() {
        return this.followingUpX;
    }

    public void setAutoScallingX(boolean autoscalling) {
        this.autoScallingX = autoscalling;
    }

    public void setAutoScallingY(boolean autoscalling) {
        this.autoScallingY = autoscalling;
    }

    public void setFollowingUpX(boolean autoscalling) {
        this.followingUpX = autoscalling;
    }

    private double calcOriginalMaxX(List datasets) {
        double max = 0.0;
        Iterator i = datasets.iterator();
        while (i.hasNext()) {
            GDataSet data = (GDataSet)i.next();
            max = Math.max(max, data.getModel().getPoints().getMaxX());
        }
        return max;
    }

    private double calcOriginalMaxY(List datasets) {
        double max = 0.0;
        Iterator i = datasets.iterator();
        while (i.hasNext()) {
            GDataSet data = (GDataSet)i.next();
            max = Math.max(max, data.getModel().getPoints().getMaxY());
        }
        return max;
    }

    private double calcOriginalMinX(List datasets) {
        double min = 0.0;
        Iterator i = datasets.iterator();
        while (i.hasNext()) {
            GDataSet data = (GDataSet)i.next();
            min = Math.min(min, data.getModel().getPoints().getMinX());
        }
        return min;
    }

    private double calcOriginalMinY(List datasets) {
        double min = 0.0;
        Iterator i = datasets.iterator();
        while (i.hasNext()) {
            GDataSet data = (GDataSet)i.next();
            min = Math.min(min, data.getModel().getPoints().getMinY());
        }
        return min;
    }

    public boolean isShowGridX() {
        return this.showGridX;
    }

    public boolean isShowGridY() {
        return this.showGridY;
    }

    public void setShowGridX(boolean showGridX) {
        this.showGridX = showGridX;
    }

    public void setShowGridY(boolean showGridY) {
        this.showGridY = showGridY;
    }
}

