/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.graph.viewer.model;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.Iterator;
import javax.swing.JViewport;
import org.boxed_economy.components.datapresentation.graph.viewer.GraphContainerPanel;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GDataSet;
import org.boxed_economy.components.datapresentation.graph.viewer.model.GGraph;

public class GGraphContainer {
    public static final int MARGIN = 25;
    private GGraph graph = new GGraph();
    private GraphContainerPanel containerPanel = new GraphContainerPanel(this);
    private Point2D.Double origin = new Point2D.Double(0.0, 0.0);
    private Dimension canvasSize;

    public void update() {
        this.graph.autoScalling(this.getContainerPanel().getGraphCanvasScrollPane().getViewport().getSize());
        this.graph.update();
        this.refreshCanvasSize();
        this.refreshCanvas();
        this.refreshOrigin();
        this.repaintCanvas();
        this.containerPanel.update();
        if (this.graph.isFollowingUpX()) {
            this.autoFollowingUp();
        }
    }

    private void autoFollowingUp() {
        Object object = this.containerPanel.getTreeLock();
        synchronized (object) {
            JViewport viewport = this.containerPanel.getGraphCanvasScrollPane().getViewport();
            Point currentViewPosition = viewport.getViewPosition();
            Point newViewPosition = new Point(currentViewPosition);
            newViewPosition.x = viewport.getView().getSize().width - viewport.getSize().width;
            if (!currentViewPosition.equals(newViewPosition)) {
                viewport.setViewPosition(newViewPosition);
            }
        }
    }

    public GraphContainerPanel getContainerPanel() {
        return this.containerPanel;
    }

    public GGraph getGraph() {
        return this.graph;
    }

    void refreshCanvasSize() {
        double maxX = this.calcMaxX();
        double maxY = this.calcMaxY();
        double minX = this.calcMinX();
        double minY = this.calcMinY();
        double w = maxX - minX + 50.0;
        double h = maxY - minY + 50.0;
        this.canvasSize = new Dimension((int)w, (int)h);
    }

    void refreshCanvas() {
        this.containerPanel.getGraphCanvas().setPreferredSize(this.getCanvasSize());
        this.containerPanel.getGraphCanvas().revalidate();
    }

    void repaintCanvas() {
        this.containerPanel.getGraphCanvas().repaint();
    }

    void refreshOrigin() {
        double minX = this.calcMinX();
        double minY = this.calcMinY();
        int bottom = Math.max(this.canvasSize.height, this.getContainerPanel().getGraphCanvasScrollPane().getHeight());
        this.origin = new Point2D.Double(-minX + 25.0, (double)bottom + minY - 25.0);
    }

    public Point2D.Double getOrigin() {
        return this.origin;
    }

    public Dimension getCanvasSize() {
        return this.canvasSize;
    }

    private double calcMaxX() {
        double max = 0.0;
        Iterator i = this.graph.getDataSets().iterator();
        while (i.hasNext()) {
            GDataSet data = (GDataSet)i.next();
            max = Math.max(max, data.getScaledPoints().getMaxX());
        }
        return max;
    }

    private double calcMaxY() {
        double max = 0.0;
        Iterator i = this.graph.getDataSets().iterator();
        while (i.hasNext()) {
            GDataSet data = (GDataSet)i.next();
            max = Math.max(max, data.getScaledPoints().getMaxY());
        }
        return max;
    }

    private double calcMinX() {
        double min = 0.0;
        Iterator i = this.graph.getDataSets().iterator();
        while (i.hasNext()) {
            GDataSet data = (GDataSet)i.next();
            min = Math.min(min, data.getScaledPoints().getMinX());
        }
        return min;
    }

    private double calcMinY() {
        double min = 0.0;
        Iterator i = this.graph.getDataSets().iterator();
        while (i.hasNext()) {
            GDataSet data = (GDataSet)i.next();
            min = Math.min(min, data.getScaledPoints().getMinY());
        }
        return min;
    }
}

