/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.report;

import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jp.ac.keio.sfc.crew.refrection.ObjectObject;
import jp.ac.keio.sfc.crew.refrection.WrapperObject;
import org.boxed_economy.besp.model.ModelContainerListener;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockListener;
import org.boxed_economy.components.datacollector.model.data.Record;
import org.boxed_economy.components.datacollector.model.fw.DataCollection;
import org.boxed_economy.components.datapresentation.AbstractDataPresentationComponent;
import org.boxed_economy.components.datapresentation.DPResource;
import org.boxed_economy.components.datapresentation.report.CSVWriter;

public class ReportComponent
extends AbstractDataPresentationComponent
implements ModelContainerListener,
UpdateClockListener,
Serializable {
    public static final String CSV = ".csv";
    public static final String DATA = "_Data";
    public static final String SETTING = "_Setting";
    private String name = "";
    private String baseDirectory = "";
    private boolean worldEnable = true;
    private boolean dateEnable = true;
    private boolean timeEnable = true;
    private boolean settingEnable = true;
    private transient CSVWriter dataOutput;

    public void initialize() {
    }

    public void terminate() {
    }

    protected void initializeWorld() {
        this.initializeNewFiles();
    }

    protected void terminateWorld() {
        this.termateFiles();
    }

    protected void step() {
        this.writeAllData();
    }

    private void initializeNewFiles() {
        this.initializeDataOutputFile();
        if (this.settingEnable) {
            this.createSettingOutputFile();
        }
    }

    private void initializeDataOutputFile() {
        File dataOutputFile = this.createNewFile(this.getDataFileName());
        this.dataOutput = new CSVWriter(dataOutputFile);
        this.writeAllHeader();
    }

    private void createSettingOutputFile() {
        File settingOutputFile = this.createNewFile(this.getSettingFileName());
        CSVWriter settingOutput = new CSVWriter(settingOutputFile);
        this.writeWorldSetting(settingOutput);
        settingOutput.close();
    }

    private void writeWorldSetting(CSVWriter settingOutput) {
        ObjectObject worldWrapper = (ObjectObject)WrapperObject.getInstance(this.getWorld());
        worldWrapper.updateAttributes();
        Map attributes = worldWrapper.getAttributes();
        Iterator i = attributes.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            Object value = attributes.get(key);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(key);
            list.add(value);
            settingOutput.writeLine(list);
        }
    }

    private File createNewFile(String fileName) {
        if (!new File(this.baseDirectory).exists()) {
            throw new RuntimeException("Directory Not Found.");
        }
        File file = new File(this.baseDirectory, fileName);
        return file;
    }

    private void termateFiles() {
        this.dataOutput.close();
        this.dataOutput = null;
    }

    private synchronized void writeAllData() {
        ArrayList<String> allData = new ArrayList<String>();
        allData.add(this.getWorld().getClock().toString());
        Iterator i = this.getDataCollections().iterator();
        while (i.hasNext()) {
            DataCollection dc = (DataCollection)i.next();
            allData.addAll(this.getData(dc));
        }
        this.dataOutput.writeLine(allData);
    }

    private synchronized List getData(DataCollection dc) {
        ArrayList data = new ArrayList();
        Iterator i = dc.getData().getRecords().iterator();
        while (i.hasNext()) {
            Record record = (Record)i.next();
            data.addAll(record.asList());
        }
        return data;
    }

    private synchronized void writeAllHeader() {
        ArrayList<String> allHeader = new ArrayList<String>();
        allHeader.add(DPResource.get("ReportComponent.Time"));
        Iterator i = this.getDataCollections().iterator();
        while (i.hasNext()) {
            DataCollection dc = (DataCollection)i.next();
            allHeader.addAll(this.getHeader(dc));
        }
        this.dataOutput.writeLine(allHeader);
    }

    private synchronized List getHeader(DataCollection dc) {
        dc.update();
        return dc.getColumns().getAsList();
    }

    public String getDataFileName() {
        return String.valueOf(this.getBaseFileName()) + DATA + CSV;
    }

    public String getSettingFileName() {
        if (this.settingEnable) {
            return String.valueOf(this.getBaseFileName()) + SETTING + CSV;
        }
        return DPResource.get("ReportComponent.No_Output");
    }

    public String getBaseFileName() {
        String baseFileName = this.name;
        if (this.timeEnable) {
            SimpleDateFormat timeFormat = new SimpleDateFormat("HHmmss");
            String timeString = timeFormat.format(new Date());
            baseFileName = String.valueOf(timeString) + "_" + baseFileName;
        }
        if (this.dateEnable) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
            String dateString = dateFormat.format(new Date());
            baseFileName = String.valueOf(dateString) + "_" + baseFileName;
        }
        if (this.worldEnable) {
            String worldName = "SimpleWorld";
            World world = this.getWorld();
            if (world != null) {
                worldName = world.getName();
            }
            baseFileName = String.valueOf(worldName) + "_" + baseFileName;
        }
        return baseFileName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(String string) {
        this.baseDirectory = string;
    }

    public boolean isDateEnable() {
        return this.dateEnable;
    }

    public boolean isSettingEnable() {
        return this.settingEnable;
    }

    public boolean isWorldEnable() {
        return this.worldEnable;
    }

    public void setDateEnable(boolean b) {
        this.dateEnable = b;
    }

    public boolean isTimeEnable() {
        return this.timeEnable;
    }

    public void setTimeEnable(boolean b) {
        this.timeEnable = b;
    }

    public void setSettingEnable(boolean b) {
        this.settingEnable = b;
    }

    public void setWorldEnable(boolean b) {
        this.worldEnable = b;
    }

    public String toString() {
        return String.valueOf(this.name) + "  --  " + this.getActiveString();
    }

    private String getActiveString() {
        if (this.isActive()) {
            return DPResource.get("ReportComponent.Active");
        }
        return DPResource.get("ReportComponent.Inactive");
    }
}

