/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.report;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jp.ac.keio.sfc.crew.swing.jface.layouts.VerticalFlowLayout;
import jp.ac.keio.sfc.crew.swing.jface.list.ElementChooser;
import org.boxed_economy.besp.presentation.PresentationContainer;
import org.boxed_economy.components.datacollector.DataCollectionContainer;
import org.boxed_economy.components.datapresentation.DPResource;
import org.boxed_economy.components.datapresentation.report.ReportComponent;

public class ReportComponentEditPanel
extends JPanel
implements DocumentListener {
    public static final int TEXT_HEIGHT = 20;
    private PresentationContainer presentationContainer = null;
    private ReportComponent reportComponent = null;
    private List dataCollections = new ArrayList();
    private boolean updating = false;
    private JFormattedTextField intervalTextField = new JFormattedTextField(new DecimalFormat());
    private JTextField nameTextField = new JTextField();
    private JTextField baseDirectoryTextField = new JTextField();
    private JCheckBox worldNameCheckBox = new JCheckBox();
    private JCheckBox dateCheckBox = new JCheckBox();
    private JCheckBox timeCheckBox = new JCheckBox();
    private JCheckBox settingCheckBox = new JCheckBox();
    private JLabel dataFileNameLabel = new JLabel();
    private JLabel settingFileNameLabel = new JLabel();
    private JLabel dataSourceLabel = new JLabel();
    private JFileChooser chooser = new JFileChooser(".");
    static /* synthetic */ Class class$0;

    public void initialize() {
        this.initializeComponent();
        this.createContentsPanels();
    }

    private void initializeComponent() {
        this.setLayout(new VerticalFlowLayout());
    }

    private void createContentsPanels() {
        this.createNamePanel();
        this.createOutputFileLocationPanel();
        this.createDataSourcePanel();
    }

    private void createNamePanel() {
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new FlowLayout(0));
        this.add(namePanel);
        JLabel nameTitleLabel = new JLabel(DPResource.get("ReportComponentEditPanel.Name"));
        namePanel.add(nameTitleLabel);
        this.nameTextField.setPreferredSize(new Dimension(300, 20));
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                ReportComponentEditPanel.this.updateModelFromView();
            }

            public void insertUpdate(DocumentEvent e) {
                ReportComponentEditPanel.this.updateModelFromView();
            }

            public void removeUpdate(DocumentEvent e) {
                ReportComponentEditPanel.this.updateModelFromView();
            }
        });
        namePanel.add(this.nameTextField);
    }

    private void createOutputFileLocationPanel() {
        JPanel fileLocationPanel = new JPanel();
        fileLocationPanel.setBorder(BorderFactory.createTitledBorder(DPResource.get("ReportComponentEditPanel.Output_File_Location")));
        fileLocationPanel.setLayout(new VerticalFlowLayout());
        this.add(fileLocationPanel);
        JPanel baseDirectoryPanel = new JPanel();
        baseDirectoryPanel.setLayout(new VerticalFlowLayout());
        fileLocationPanel.add(baseDirectoryPanel);
        JLabel baseDirectoryTitleLabel = new JLabel(DPResource.get("ReportComponentEditPanel.Base_Directory"));
        baseDirectoryPanel.add(baseDirectoryTitleLabel);
        JPanel baseDirectoryChoosePanel = new JPanel();
        baseDirectoryChoosePanel.setLayout(new FlowLayout(0));
        baseDirectoryPanel.add(baseDirectoryChoosePanel);
        this.baseDirectoryTextField.setPreferredSize(new Dimension(400, 20));
        baseDirectoryChoosePanel.add(this.baseDirectoryTextField);
        JButton pathButton = new JButton("....");
        pathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReportComponentEditPanel.this.doSelectBaseDirectory();
            }
        });
        baseDirectoryChoosePanel.add(pathButton);
        JPanel fileNamePanel = new JPanel();
        fileNamePanel.setLayout(new VerticalFlowLayout());
        fileLocationPanel.add(fileNamePanel);
        JLabel fileNameTitleLabel = new JLabel(DPResource.get("ReportComponentEditPanel.File_Name"));
        fileNamePanel.add(fileNameTitleLabel);
        JPanel fileNameSettingPanel = new JPanel();
        fileNameSettingPanel.setLayout(new FlowLayout(1));
        fileNamePanel.add(fileNameSettingPanel);
        this.installCheckBox(fileNameSettingPanel, this.worldNameCheckBox, DPResource.get("ReportComponentEditPanel.World_Name"));
        this.installCheckBox(fileNameSettingPanel, this.dateCheckBox, DPResource.get("ReportComponentEditPanel.Date"));
        this.installCheckBox(fileNameSettingPanel, this.timeCheckBox, DPResource.get("ReportComponentEditPanel.Time"));
        this.installCheckBox(fileNameSettingPanel, this.settingCheckBox, DPResource.get("ReportComponentEditPanel.Setting"));
        this.createFileNamePanel(fileNamePanel, DPResource.get("ReportComponentEditPanel.Data_File_Name"), this.dataFileNameLabel);
        this.createFileNamePanel(fileNamePanel, DPResource.get("ReportComponentEditPanel.Setting_File_Name"), this.settingFileNameLabel);
        this.createIntervalPanel();
    }

    private void installCheckBox(JComponent container, JCheckBox checkBox, String text) {
        checkBox.setText(text);
        container.add(checkBox);
        checkBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ReportComponentEditPanel.this.updateModelFromView();
            }
        });
    }

    private void createFileNamePanel(JPanel fileNamePanel, String title, JLabel nameLabel) {
        JPanel dataFileNamePanel = new JPanel();
        dataFileNamePanel.setLayout(new FlowLayout(0));
        fileNamePanel.add(dataFileNamePanel);
        JLabel fileNameTitleLabel = new JLabel(title);
        dataFileNamePanel.add(fileNameTitleLabel);
        dataFileNamePanel.add(nameLabel);
    }

    private void createDataSourcePanel() {
        JPanel dataSourcePanel = new JPanel();
        dataSourcePanel.setBorder(BorderFactory.createTitledBorder(DPResource.get("ReportComponentEditPanel.Data_Source")));
        dataSourcePanel.setLayout(new VerticalFlowLayout());
        this.add(dataSourcePanel);
        JLabel dataCollectionTitleLabel = new JLabel(DPResource.get("ReportComponentEditPanel.Data_Collection"));
        dataSourcePanel.add(dataCollectionTitleLabel);
        JPanel dataCollectionPanel = new JPanel();
        dataCollectionPanel.setLayout(new FlowLayout(0));
        dataSourcePanel.add(dataCollectionPanel);
        this.dataSourceLabel.setPreferredSize(new Dimension(400, 20));
        dataCollectionPanel.add(this.dataSourceLabel);
        JButton dataCollectionButton = new JButton("....");
        dataCollectionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReportComponentEditPanel.this.doSelectDataCollection();
            }
        });
        dataCollectionPanel.add(dataCollectionButton);
    }

    private void createIntervalPanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createTitledBorder(DPResource.get("ReportComponentEditPanel.Output_Interval")));
        panel.setLayout(new VerticalFlowLayout());
        this.add(panel);
        this.intervalTextField.setPreferredSize(new Dimension(100, 20));
        panel.add(this.intervalTextField);
    }

    protected void doSelectBaseDirectory() {
        this.chooser.setCurrentDirectory(new File(this.reportComponent.getBaseDirectory()));
        this.chooser.setFileSelectionMode(1);
        int result = this.chooser.showDialog(this, DPResource.get("ReportComponentEditPanel.Select"));
        if (result == 0) {
            File file = this.chooser.getSelectedFile();
            this.baseDirectoryTextField.setText(file.getAbsolutePath());
        }
        this.updateModelFromView();
    }

    protected void doSelectDataCollection() {
        List selected = ElementChooser.open(this.getOwner(), this.getDataCollections(), this.getSelectedCollections(), DPResource.get("ReportComponentEditPanel.Choose_DataCollection"), DPResource.get("ReportComponentEditPanel.Choose_Single_DataCollection"), DPResource.get("ReportComponentEditPanel.DataCollection_List"), DPResource.get("ReportComponentEditPanel.Chosen_DataCollection"));
        if (selected != null) {
            this.dataCollections = selected;
            this.updateModelFromView();
        }
    }

    public void updateViewFromModel() {
        if (this.reportComponent != null) {
            this.updating = true;
            this.nameTextField.setText(this.reportComponent.getName());
            this.baseDirectoryTextField.setText(this.reportComponent.getBaseDirectory());
            this.worldNameCheckBox.setSelected(this.reportComponent.isWorldEnable());
            this.dateCheckBox.setSelected(this.reportComponent.isDateEnable());
            this.timeCheckBox.setSelected(this.reportComponent.isTimeEnable());
            this.settingCheckBox.setSelected(this.reportComponent.isSettingEnable());
            this.dataCollections = this.reportComponent.getDataCollections();
            this.refreshDataCollectionLabel();
            this.intervalTextField.getDocument().removeDocumentListener(this);
            int interval = this.getReportComponent().getStepInterval();
            this.intervalTextField.setText(Integer.toString(interval));
            this.intervalTextField.getDocument().addDocumentListener(this);
            this.updating = false;
        }
        this.refreshFileNames();
    }

    public void updateModelFromView() {
        if (!this.updating && this.reportComponent != null) {
            this.reportComponent.setName(this.nameTextField.getText());
            this.reportComponent.setBaseDirectory(this.baseDirectoryTextField.getText());
            this.reportComponent.setDateEnable(this.dateCheckBox.isSelected());
            this.reportComponent.setTimeEnable(this.timeCheckBox.isSelected());
            this.reportComponent.setWorldEnable(this.worldNameCheckBox.isSelected());
            this.reportComponent.setSettingEnable(this.settingCheckBox.isSelected());
            this.reportComponent.setDataCollections(this.dataCollections);
        }
        this.refreshDataCollectionLabel();
        this.refreshFileNames();
    }

    public void refreshFileNames() {
        this.dataFileNameLabel.setText(this.reportComponent.getDataFileName());
        this.settingFileNameLabel.setText(this.reportComponent.getSettingFileName());
    }

    private void refreshDataCollectionLabel() {
        if (this.reportComponent != null) {
            List dataCollections = this.reportComponent.getDataCollections();
            this.dataSourceLabel.setText(dataCollections.toString());
            return;
        }
        this.dataSourceLabel.setText(DPResource.get("ReportComponentEditPanel.No_Assignment"));
    }

    public boolean doOK() {
        if (this.reportComponent == null) {
            return false;
        }
        if (this.dataCollections == null) {
            return false;
        }
        this.updateModelFromView();
        return true;
    }

    public ReportComponent getReportComponent() {
        return this.reportComponent;
    }

    public void setReportComponent(ReportComponent component) {
        this.reportComponent = component;
        this.updateViewFromModel();
    }

    public PresentationContainer getPresentationContainer() {
        return this.presentationContainer;
    }

    public void setPresentationContainer(PresentationContainer container) {
        this.presentationContainer = container;
    }

    private List getSelectedCollections() {
        ArrayList list = new ArrayList();
        list.addAll(this.dataCollections);
        return list;
    }

    private List getDataCollections() {
        PresentationContainer presentationContainer = this.getPresentationContainer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.components.datacollector.DataCollectionContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DataCollectionContainer dcContainer = (DataCollectionContainer)presentationContainer.getPresentationComponent(clazz);
        return dcContainer.getManager().getDataCollections();
    }

    private Frame getOwner() {
        Container comp = this;
        while (!(comp instanceof Frame)) {
            comp = comp.getParent();
        }
        return (Frame)comp;
    }

    public void changedUpdate(DocumentEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        this.setInterval();
    }

    public void removeUpdate(DocumentEvent e) {
        this.setInterval();
    }

    private void setInterval() {
        try {
            int newInterval = Integer.parseInt(this.intervalTextField.getText());
            this.getReportComponent().setStepInterval(newInterval);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

