/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.datapresentation.report;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jp.ac.keio.sfc.crew.swing.jface.layouts.VerticalFlowLayout;
import jp.ac.keio.sfc.crew.swing.jface.list.ListPanel;
import org.boxed_economy.besp.presentation.PresentationContainer;
import org.boxed_economy.components.datapresentation.DPResource;
import org.boxed_economy.components.datapresentation.report.ReportComponent;
import org.boxed_economy.components.datapresentation.report.ReportComponentEditPanel;
import org.boxed_economy.components.datapresentation.report.ReportContainer;

public class ReportComponentManagementPanel
extends JPanel {
    private PresentationContainer presentationContainer = null;
    private ListPanel reportComponentsPanel = new ListPanel();
    private JPanel buttonsPanel = new JPanel();
    private JButton createButton = new JButton();
    private JButton editButton = new JButton();
    private JButton removeButton = new JButton();
    private JButton activateButton = new JButton();
    private JButton deactivateButton = new JButton();
    static /* synthetic */ Class class$0;

    public void initialize() {
        this.setLayout(new BorderLayout());
        this.initializeReportComponentsPanel();
        this.initializeButtonsPanel();
        this.add((Component)this.buttonsPanel, "East");
        this.add((Component)this.reportComponentsPanel, "Center");
    }

    private void initializeReportComponentsPanel() {
        this.reportComponentsPanel.getJList().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ReportComponentManagementPanel.this.buttonStateUpdate();
            }
        });
        this.updateCollectionsPanel();
    }

    private void initializeButtonsPanel() {
        this.buttonsPanel.setLayout(new VerticalFlowLayout());
        this.createButton.setText(DPResource.get("ReportComponentManagementPanel.Create"));
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReportComponentManagementPanel.this.doCreate();
            }
        });
        this.buttonsPanel.add(this.createButton);
        this.editButton.setText(DPResource.get("ReportComponentManagementPanel.Edit"));
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReportComponentManagementPanel.this.doEdit();
            }
        });
        this.buttonsPanel.add(this.editButton);
        this.activateButton.setText(DPResource.get("ReportComponentManagementPanel.Activate"));
        this.activateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReportComponentManagementPanel.this.doActive();
            }
        });
        this.buttonsPanel.add(this.activateButton);
        this.deactivateButton.setText(DPResource.get("ReportComponentManagementPanel.Deactivate"));
        this.deactivateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReportComponentManagementPanel.this.doDeactive();
            }
        });
        this.buttonsPanel.add(this.deactivateButton);
        this.removeButton.setText(DPResource.get("ReportComponentManagementPanel.Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ReportComponentManagementPanel.this.doRemove();
            }
        });
        this.buttonsPanel.add(this.removeButton);
        this.buttonStateUpdate();
    }

    private void buttonStateUpdate() {
        Object[] objects = this.reportComponentsPanel.getJList().getSelectedValues();
        if (objects.length > 0) {
            this.removeButton.setEnabled(true);
            this.activateButton.setEnabled(true);
            this.deactivateButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
            this.activateButton.setEnabled(false);
            this.deactivateButton.setEnabled(false);
        }
        if (objects.length == 1) {
            this.editButton.setEnabled(true);
        } else {
            this.editButton.setEnabled(false);
        }
    }

    private void doActive() {
        this.setActive(true);
    }

    private void doDeactive() {
        this.setActive(false);
    }

    private void doCreate() {
        this.createOpen();
        this.updateCollectionsPanel();
    }

    private void doEdit() {
        Object object = this.reportComponentsPanel.getJList().getSelectedValue();
        this.editOpen((ReportComponent)object);
        this.updateCollectionsPanel();
    }

    private void doRemove() {
        Object[] objects = this.reportComponentsPanel.getJList().getSelectedValues();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof ReportComponent) {
                this.getContainer().removeReportComponent((ReportComponent)objects[i]);
            }
            ++i;
        }
        this.updateCollectionsPanel();
    }

    private void setActive(boolean active) {
        Object[] objects = this.reportComponentsPanel.getJList().getSelectedValues();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof ReportComponent) {
                ((ReportComponent)objects[i]).setActive(active);
            }
            ++i;
        }
        this.updateCollectionsPanel();
    }

    private void updateCollectionsPanel() {
        this.reportComponentsPanel.setList(this.getContainer().getReportComponents());
    }

    public ReportContainer getContainer() {
        PresentationContainer presentationContainer = this.getPresentationContainer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.components.datapresentation.report.ReportContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ReportContainer)presentationContainer.getPresentationComponent(clazz);
    }

    public PresentationContainer getPresentationContainer() {
        return this.presentationContainer;
    }

    public void setPresentationContainer(PresentationContainer container) {
        this.presentationContainer = container;
    }

    public void createOpen() {
        ReportComponent reportComponent = new ReportComponent();
        reportComponent.setName("New Report");
        int result = this.editOpen(reportComponent);
        if (result == 0) {
            this.getContainer().addReportComponent(reportComponent);
        }
    }

    public int editOpen(ReportComponent reportComponent) {
        ReportComponentEditPanel editor = new ReportComponentEditPanel();
        editor.setReportComponent(reportComponent);
        editor.setPresentationContainer(this.getPresentationContainer());
        editor.initialize();
        int result = JOptionPane.showConfirmDialog(this.presentationContainer.getMainFrame(), editor, DPResource.get("ReportComponentManagementPanel.Report_Component_Editor"), 2, -1, null);
        if (result == 0 && editor.doOK()) {
            return result;
        }
        return 2;
    }
}

