/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.language;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import jp.ac.keio.sfc.crew.swing.jface.layouts.VerticalFlowLayout;
import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.components.language.LanguageResource;
import org.boxed_economy.components.property.ApplyPropertyException;
import org.boxed_economy.components.property.PropertyPanel;

public class LanguageSelectionPanel
extends PropertyPanel {
    private static final String DEFAULT_LANGUAGE_KEY = "default";
    private static final Map LANGUAGES = new LinkedHashMap();
    private static final Map LANGUAGE_KEYS = new LinkedHashMap();
    private JLabel label = new JLabel();
    private JComboBox comboBox = new JComboBox();

    static {
        LanguageSelectionPanel.installLanguage(DEFAULT_LANGUAGE_KEY, LanguageResource.get("LanguageSelectionPanel.Default"));
        LanguageSelectionPanel.installLanguage("ja", LanguageResource.get("LanguageSelectionPanel.Japanese"));
        LanguageSelectionPanel.installLanguage("en", LanguageResource.get("LanguageSelectionPanel.English"));
    }

    private static void installLanguage(String key, String name) {
        LANGUAGES.put(key, name);
        LANGUAGE_KEYS.put(name, key);
    }

    public void initialize() {
        this.setTitle(LanguageResource.get("LanguageSelectionPanel.Language"));
        this.label.setText(LanguageResource.get("LanguageSelectionPanel.Valid_Message"));
        Iterator i = LANGUAGES.values().iterator();
        while (i.hasNext()) {
            this.comboBox.addItem(i.next());
        }
        this.setLayout(new VerticalFlowLayout());
        this.add(this.label);
        this.add(this.comboBox);
    }

    public void showCurrentSetting() {
        String locale;
        if (this.hasFile() && this.hasLocale(locale = this.readFile())) {
            this.comboBox.setSelectedItem(LANGUAGES.get(locale));
        }
    }

    private boolean hasFile() {
        return this.getFile().exists();
    }

    private File getFile() {
        File file = new File(BESP.boxHome, "besp.locale");
        return file;
    }

    private String readFile() {
        try {
            BufferedReader br = new BufferedReader(new FileReader(this.getFile()));
            String locale = br.readLine();
            br.close();
            return locale;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private void writeFile(String locale) {
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.getFile()));
            bw.write(locale);
            bw.close();
        }
        catch (Exception ex) {
            return;
        }
    }

    private void deleteFile() {
        if (this.hasFile()) {
            this.getFile().delete();
        }
    }

    private boolean hasLocale(String locale) {
        return LANGUAGES.get(locale) != null;
    }

    public void applyNewSetting() throws ApplyPropertyException {
        String key = (String)LANGUAGE_KEYS.get(this.comboBox.getSelectedItem());
        if (key.equals(DEFAULT_LANGUAGE_KEY)) {
            this.deleteFile();
        } else {
            this.writeFile(key);
        }
    }
}

