/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.property;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import org.boxed_economy.besp.presentation.PresentationContainer;
import org.boxed_economy.components.property.ApplyPropertyException;
import org.boxed_economy.components.property.PropertyManagerPlugin;
import org.boxed_economy.components.property.PropertyPanel;

public class PropertyDialog
extends JDialog {
    public static ResourceBundle resource = PropertyManagerPlugin.resource;
    private PresentationContainer presentationContainer = null;
    private List propertyPanels = new ArrayList();
    private JTabbedPane tabbedPane = new JTabbedPane();

    public PropertyDialog(Frame owner, PresentationContainer presentationContainer) {
        super(owner);
        this.presentationContainer = presentationContainer;
    }

    public void show() {
        this.showCurrentSetting();
        while (true) {
            try {
                int res = JOptionPane.showConfirmDialog(this.getOwner(), this.tabbedPane, resource.getString("Title_PropertyDialog"), 2, -1);
                if (res != 0) break;
                this.applyNewSetting();
            }
            catch (ApplyPropertyException ex) {
                this.presentationContainer.showError(ex.getMessage(), ex);
                continue;
            }
            break;
        }
    }

    public void installPropertyPanel(PropertyPanel panel) {
        panel.setContainer(this.presentationContainer.getContainer());
        panel.initialize();
        this.tabbedPane.add(panel.getTitle(), panel);
        this.propertyPanels.add(panel);
    }

    private void showCurrentSetting() {
        Iterator i = this.propertyPanels.iterator();
        while (i.hasNext()) {
            PropertyPanel element = (PropertyPanel)i.next();
            element.showCurrentSetting();
        }
    }

    private void applyNewSetting() throws ApplyPropertyException {
        Iterator i = this.propertyPanels.iterator();
        while (i.hasNext()) {
            PropertyPanel element = (PropertyPanel)i.next();
            element.applyNewSetting();
        }
    }
}

