/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.realclock;

import org.boxed_economy.besp.model.LimitedTimeRunSetting;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.components.realclock.RealClock;
import org.boxed_economy.components.realclock.Time;
import org.boxed_economy.components.realclock.TimeOfDay;

public abstract class AbstractRealClockLimitedTimeRunSetting
extends LimitedTimeRunSetting {
    private RealClock clock;

    public AbstractRealClockLimitedTimeRunSetting(RealClock clock) {
        this.clock = clock;
    }

    public RealClock getClock() {
        return this.clock;
    }

    public long getStep() {
        if (this.calculateStepNum() <= 0L) {
            throw new ModelException("calculated step is below zero (step = " + this.calculateStepNum() + ")");
        }
        return this.calculateStepNum();
    }

    public abstract TimeOfDay getEndTimeOfDay();

    private long calculateStepNum() {
        Time timeForStep = this.clock.getTimeForStep();
        TimeOfDay startTimeOfDay = this.clock.getCurrentTimeOfDay();
        long stepNum = timeForStep.isCovertableSecond() ? (long)Math.ceil(this.getEndTimeOfDay().getTimeDifference(startTimeOfDay).divide(timeForStep)) : (long)Math.ceil(this.getEndTimeOfDay().getMonthDifference(startTimeOfDay).divide(timeForStep));
        return stepNum;
    }
}

