/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.realclock;

import java.io.Serializable;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.components.realclock.RealClockPlugin;

public class Time
implements Serializable,
Comparable {
    public static ResourceBundle resource = RealClockPlugin.resource;
    private static final Logger logger;
    public static final String second = "second";
    public static final String minute = "minute";
    public static final String hour = "hour";
    public static final String day = "day";
    public static final String month = "month";
    public static final String year = "year";
    private String unit;
    private long length;
    private long milliSecond;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.components.realclock.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public Time(long newlength, String newunit) {
        this.checkUnit(newunit);
        this.length = newlength;
        this.unit = newunit;
    }

    private void checkUnit(String checkUnit) {
        logger.debug((Object)("Time#checkUnit() checkUnit=" + checkUnit));
        if (checkUnit.equals(year) || checkUnit.equals(month) || checkUnit.equals(day) || checkUnit.equals(hour) || checkUnit.equals(minute) || checkUnit.equals(second)) {
            return;
        }
        throw new ModelException("\u9055\u6cd5\u306aTime\u306eunit\u304c\u4f7f\u7528\u3055\u308c\u307e\u3057\u305f\u3002 \u4f7f\u7528\u3057\u3088\u3046\u3068\u3057\u305funit=" + this.unit);
    }

    private Time() {
    }

    public Time add(Time addTime) {
        return this.addWithAtomicUnit(addTime);
    }

    public Time remove(Time removeTime) {
        return this.addWithAtomicUnit(removeTime.reverseSign());
    }

    private Time addWithAtomicUnit(Time addTime) {
        if (!this.isCalculatable(addTime)) {
            throw new ModelException("\u4e92\u3044\u306ehour\u306f\u8a08\u7b97\u53ef\u80fd\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
        }
        long \u5408\u8a08length = this.getTimeByAtomicUnit().getLength() + addTime.getTimeByAtomicUnit().getLength();
        String \u8a08\u7b97\u7d50\u679cunit = this.getTimeByAtomicUnit().getUnit();
        return new Time((int)\u5408\u8a08length, \u8a08\u7b97\u7d50\u679cunit);
    }

    private boolean isCalculatable(Time targethour) {
        if (this.isCovertableSecond()) {
            return targethour.isCovertableSecond();
        }
        return !targethour.isCovertableSecond();
    }

    private Time getTimeByAtomicUnit() {
        if (this.isCovertableSecond()) {
            return new Time((int)this.getSecondNum(), second);
        }
        return new Time((int)this.getMonthNum(), month);
    }

    public boolean isCovertableSecond() {
        return !this.unit.equals(year) && !this.unit.equals(month);
    }

    private long getSecondNum() {
        if (this.unit.equals(day)) {
            return this.length * 60L * 60L * 24L;
        }
        if (this.unit.equals(hour)) {
            return this.length * 60L * 60L;
        }
        if (this.unit.equals(minute)) {
            return this.length * 60L;
        }
        if (this.unit.equals(second)) {
            return this.length;
        }
        throw new ModelException("hour\u306eunit\u304c" + this.unit + "\u3067\u3042\u308b\u306b\u3082\u95a2\u308f\u3089\u305a\u3001second\u6570\u3092\u8fd4\u3059()\u30e1\u30bd\u30c3\u30c9\u3092run\u3057\u307e\u3057\u305f\u3002");
    }

    private long getMonthNum() {
        if (this.unit.equals(year)) {
            return this.length * 12L;
        }
        if (this.unit.equals(month)) {
            return this.length;
        }
        throw new ModelException("hour\u306eunit\u304cmonth\u304byear\u3067\u306f\u306a\u3044\u306b\u3082\u95a2\u308f\u3089\u305a\u3001month\u6570\u3092\u8fd4\u3059()\u30e1\u30bd\u30c3\u30c9\u3092run\u3057\u307e\u3057\u305f\u3002");
    }

    private Time reverseSign() {
        return new Time(-this.getLength(), this.getUnit());
    }

    public double divide(Time targethour) throws ModelException {
        if (targethour.isZero()) {
            throw new ModelException("Time#divide hour\uff10\u3067divide\u3092\u8a08\u7b97\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f\u3002");
        }
        if (!this.isCalculatable(targethour)) {
            throw new ModelException("\u4e92\u3044\u306ehour\u306f\u8a08\u7b97\u53ef\u80fd\u3067\u306f\u3042\u308a\u307e\u305b\u3093");
        }
        return (double)this.getTimeByAtomicUnit().getLength() / (double)targethour.getTimeByAtomicUnit().getLength();
    }

    public boolean isZero() {
        return this.length == 0L;
    }

    public boolean isPositive() {
        return this.length > 0L;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long newLength) {
        this.length = newLength;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String newUnit) {
        this.unit = newUnit;
    }

    public boolean equals(Object target) {
        if (!(target instanceof Time)) {
            return false;
        }
        if (!this.isCalculatable((Time)target)) {
            return false;
        }
        return this.getTimeByAtomicUnit().getLength() == ((Time)target).getTimeByAtomicUnit().getLength();
    }

    public int hashCode() {
        return this.getTimeByAtomicUnit().toString().hashCode();
    }

    public String toString() {
        return String.valueOf(this.getLength()) + resource.getString(this.getUnit());
    }

    public int compareTo(Object target) {
        try {
            Time targetTime = (Time)target;
            if (this.isCalculatable(targetTime)) {
                throw new ModelException("\u8a08\u7b97\u4e0d\u80fd\u306a\u3082\u306e\u3092\u6bd4\u8f03\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f");
            }
            long \u5dee = this.getTimeByAtomicUnit().getLength() - targetTime.getTimeByAtomicUnit().getLength();
            if (\u5dee > 0L) {
                return 1;
            }
            if (\u5dee == 0L) {
                return 0;
            }
            return -1;
        }
        catch (ClassCastException \u30af\u30e9\u30b9\u30ad\u30e3\u30b9\u30c8exception) {
            throw new ModelException("DefaultTime\u3068\u305d\u3046\u3067\u306f\u306a\u3044\u3082\u306e\u3092\u6bd4\u8f03\u3057\u3088\u3046\u3068\u3057\u307e\u3057\u305f\u3002");
        }
    }
}

