/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.realclock;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.log4j.Logger;
import org.boxed_economy.components.property.ApplyPropertyException;
import org.boxed_economy.components.realclock.RealClock;
import org.boxed_economy.components.realclock.RealClockPlugin;
import org.boxed_economy.components.realclock.SetTimeForStepCommand;
import org.boxed_economy.components.realclock.Time;
import org.boxed_economy.components.realclock.TimeUnitSelectComboBoxModel;
import org.boxed_economy.components.runsetting.RunSettingPanel;

public class TimeForStepRunSettingPanel
extends RunSettingPanel {
    public static ResourceBundle resource = RealClockPlugin.resource;
    private static final Logger logger;
    private JComboBox comboBoxStepUnit = new JComboBox(new TimeUnitSelectComboBoxModel());
    private JLabel labelFor1Step = new JLabel();
    private JLabel labelAs = new JLabel();
    private JTextField textFieldStepNum = new JTextField();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.components.realclock.TimeForStepRunSettingPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public void initialize() {
        FlowLayout layout = new FlowLayout();
        this.setLayout(layout);
        layout.setAlignment(0);
        this.setPreferredSize(new Dimension(288, 45));
        this.labelFor1Step.setText(resource.getString("Label_For1Step"));
        this.add((Component)this.labelFor1Step, null);
        this.textFieldStepNum.setPreferredSize(new Dimension(40, 21));
        this.textFieldStepNum.setHorizontalAlignment(4);
        this.add((Component)this.textFieldStepNum, null);
        this.comboBoxStepUnit.setPreferredSize(new Dimension(80, 21));
        this.add((Component)this.comboBoxStepUnit, null);
        this.labelAs.setText(resource.getString("Label_As"));
        this.add((Component)this.labelAs, null);
    }

    public String getTitle() {
        return resource.getString("Title_TimeForStepSetting");
    }

    public void showCurrentSetting() {
        RealClock clock = (RealClock)this.getClock();
        Time time = clock.getTimeForStep();
        this.textFieldStepNum.setText(String.valueOf(time.getLength()));
        this.comboBoxStepUnit.setSelectedItem(time.getUnit());
    }

    public void applyNewSetting() throws ApplyPropertyException {
        try {
            long num = Long.parseLong(this.textFieldStepNum.getText());
            if (num <= 0L) {
                throw new ApplyPropertyException("illegal number set - below zero");
            }
            Time time = new Time(num, this.comboBoxStepUnit.getSelectedItem().toString());
            logger.debug((Object)("setTimeforStep" + num + ":" + this.comboBoxStepUnit.getSelectedItem().toString()));
            new SetTimeForStepCommand(this.getContainer(), time).execute();
        }
        catch (NumberFormatException ex) {
            throw new ApplyPropertyException("illegal number format");
        }
        catch (Exception ex) {
            this.getPresentationContainer().showError("Error in TimeForStepRunSetting", ex);
        }
    }
}

