/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.realclock;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.boxed_economy.components.property.ApplyPropertyException;
import org.boxed_economy.components.realclock.RealClock;
import org.boxed_economy.components.realclock.RealClockPlugin;
import org.boxed_economy.components.realclock.Time;
import org.boxed_economy.components.realclock.TimeLimitedTimeRunSetting;
import org.boxed_economy.components.realclock.TimeUnitSelectComboBoxModel;
import org.boxed_economy.components.runsetting.LimitedTimeRunSettingPanel;

public class TimeLimitedTimeRunSettingPanel
extends LimitedTimeRunSettingPanel {
    public static ResourceBundle resource = RealClockPlugin.resource;
    private JLabel labelBy = new JLabel();
    private JComboBox comboBoxTimeUnitSelect = new JComboBox(new TimeUnitSelectComboBoxModel());
    private JTextField textFieldTimeInput = new JTextField();
    static /* synthetic */ Class class$0;

    public void initialize() {
        this.setPreferredSize(new Dimension(288, 35));
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        this.setLayout(flowLayout);
        this.labelBy.setText(resource.getString("Label_By"));
        this.add(this.labelBy);
        this.textFieldTimeInput.setPreferredSize(new Dimension(38, 21));
        this.textFieldTimeInput.setHorizontalAlignment(4);
        this.add((Component)this.textFieldTimeInput, null);
        this.comboBoxTimeUnitSelect.setPreferredSize(new Dimension(80, 21));
        this.add((Component)this.comboBoxTimeUnitSelect, null);
    }

    public String getTitle() {
        return resource.getString("Title_ByTime");
    }

    public void showCurrentSetting() {
        try {
            TimeLimitedTimeRunSetting currentSetting = (TimeLimitedTimeRunSetting)this.getLimitedTimeRunSetting();
            Time time = currentSetting.getRunTime();
            this.textFieldTimeInput.setText(String.valueOf(time.getLength()));
            this.comboBoxTimeUnitSelect.setSelectedItem(time.getUnit());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void applyNewSetting() throws ApplyPropertyException {
        try {
            String unit = (String)this.comboBoxTimeUnitSelect.getSelectedItem();
            int num = Integer.parseInt(this.textFieldTimeInput.getText());
            if (num <= 0) {
                throw new ApplyPropertyException("illegal value set - below zero.");
            }
            RealClock clock = (RealClock)this.getClock();
            TimeLimitedTimeRunSetting newSetting = new TimeLimitedTimeRunSetting(clock, new Time(num, unit));
            this.getModelContainer().setLimitedRunSetting(newSetting);
        }
        catch (NumberFormatException ex) {
            throw new ApplyPropertyException(ex);
        }
        catch (Exception ex) {
            throw new ApplyPropertyException(ex);
        }
    }

    protected boolean isCurrentTimeRunSetting() {
        Class<?> clazz = this.getLimitedTimeRunSetting().getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.boxed_economy.components.realclock.TimeLimitedTimeRunSetting");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.equals(clazz2);
    }
}

