/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.runsetting;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.model.fmfw.Clock;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.components.property.ApplyPropertyException;
import org.boxed_economy.components.runsetting.RunSettingManager;
import org.boxed_economy.components.runsetting.RunSettingManagerPlugin;
import org.boxed_economy.components.runsetting.RunSettingPanel;

public class RunSettingDialog
extends JDialog {
    public static ResourceBundle resource = RunSettingManagerPlugin.resource;
    private static final Logger logger;
    private BESPContainer container = null;
    private RunSettingManager manager = null;
    private Map panels = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.components.runsetting.RunSettingDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public RunSettingDialog(RunSettingManager manager, BESPContainer container) {
        super(container.getPresentationContainer().getMainFrame());
        this.container = container;
        this.manager = manager;
    }

    public void installRunSettingPanel(Class clockClass, RunSettingPanel runSettingPanel) {
        runSettingPanel.setContainer(this.container);
        runSettingPanel.initialize();
        this.panels.put(clockClass, runSettingPanel);
        logger.info((Object)(String.valueOf(clockClass.getName()) + " installed in RunSettingPanel"));
    }

    private RunSettingPanel getRunSettingPanel() {
        Clock clock = this.getClock();
        if (this.getClock() == null) {
            return null;
        }
        RunSettingPanel panel = (RunSettingPanel)this.panels.get(this.getClock().getClass());
        return panel;
    }

    private Clock getClock() {
        World model = this.container.getModelContainer().getModel();
        if (model == null) {
            return null;
        }
        return model.getClock();
    }

    public void show() {
        RunSettingPanel panel = this.getRunSettingPanel();
        if (panel == null) {
            this.showNullDialog();
        } else {
            panel.showCurrentSetting();
            this.showDialog(panel);
        }
    }

    private void showDialog(RunSettingPanel panel) {
        while (true) {
            try {
                int res = JOptionPane.showConfirmDialog(this.getOwner(), panel, resource.getString("Title_RunSetting"), 2, -1);
                if (res != 0) break;
                panel.applyNewSetting();
                this.manager.getExtendPanel().refresh();
            }
            catch (ApplyPropertyException ex) {
                this.container.getPresentationContainer().showError(ex.getMessage(), ex);
                continue;
            }
            break;
        }
    }

    private void showNullDialog() {
        JOptionPane.showMessageDialog(this.getOwner(), "\u5bfe\u5fdc\u3059\u308bPanel\u304c\u30a4\u30f3\u30b9\u30c8\u30fc\u30eb\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }
}

