/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.runsetting;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.boxed_economy.besp.model.LimitedTimeRunSetting;
import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.model.fmfw.Clock;
import org.boxed_economy.besp.presentation.bface.menu.Action;
import org.boxed_economy.components.runsetting.RunSettingManagerPlugin;

public class RunSettingShowExtendPanel
extends JPanel {
    public static ResourceBundle resource = RunSettingManagerPlugin.resource;
    private ModelContainer modelContainer = null;
    private Action runSettingAction = null;
    private JLabel labelClock = new JLabel();
    private JLabel labelLimitedTimeRun = new JLabel();

    public RunSettingShowExtendPanel(ModelContainer modelContainer, Action runSettingAction) {
        this.modelContainer = modelContainer;
        this.runSettingAction = runSettingAction;
        this.initialize();
        this.refresh();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        JButton runSettingButton = new JButton(this.runSettingAction);
        JPanel buttonPanel = new JPanel();
        this.add((Component)buttonPanel, "East");
        buttonPanel.add(runSettingButton);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BorderLayout());
        labelPanel.add((Component)this.labelClock, "North");
        labelPanel.add((Component)this.labelLimitedTimeRun, "South");
        this.add((Component)labelPanel, "Center");
    }

    public void refresh() {
        this.showCurrentClock();
        this.showCurrentLimitedTimeRunSetting();
        this.validate();
        this.revalidate();
        this.validateTree();
    }

    protected void showCurrentClock() {
        Clock clock = this.getClock();
        if (clock != null) {
            this.labelClock.setText(clock.toString());
        }
    }

    protected void showCurrentLimitedTimeRunSetting() {
        LimitedTimeRunSetting limitedTimeRunSetting = this.modelContainer.getLimitedTimeRunSetting();
        if (limitedTimeRunSetting != null) {
            String separator = " : ";
            this.labelLimitedTimeRun.setText(String.valueOf(resource.getString("Label_LimitedTimeRunSetting")) + separator + limitedTimeRunSetting.getDescription());
        }
    }

    private Clock getClock() {
        if (this.modelContainer.getModel() == null) {
            return null;
        }
        return this.modelContainer.getModel().getClock();
    }
}

