/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.components.worldinitializer;

import java.awt.Component;
import java.beans.PropertyDescriptor;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.boxed_economy.components.worldinitializer.WorldInitializerPlugin;

public class InitializerTableModel
extends AbstractTableModel {
    private static final Logger logger;
    private static final String COMMENT_METHOD_SURFIX = "Comment";
    public static ResourceBundle resource;
    private List descriptors = null;
    private Object currentObject = null;
    private Object defaultObject = null;
    private List editableValues = null;
    private Component comp = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.components.worldinitializer.InitializerTableModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
        resource = WorldInitializerPlugin.resource;
    }

    public InitializerTableModel(Object source, List discriptors, Component view) {
        try {
            this.currentObject = source;
            this.defaultObject = source.getClass().newInstance();
            this.descriptors = discriptors;
            this.comp = view;
            this.initializeEditedProperties();
        }
        catch (InstantiationException ex) {
            logger.warn((Object)"instantiation failed", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            logger.warn((Object)"This constructor is not accessable.", (Throwable)ex);
        }
    }

    public void initializeEditedProperties() {
        this.editableValues = new ArrayList();
        int i = 0;
        while (i < this.descriptors.size()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)this.descriptors.get(i);
            this.editableValues.add(this.parseObject(descriptor, this.getCurrentValue(descriptor)));
            ++i;
        }
    }

    public void applyDefaultProperties() {
        this.editableValues = new ArrayList();
        int i = 0;
        while (i < this.descriptors.size()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)this.descriptors.get(i);
            this.editableValues.add(this.parseObject(descriptor, this.getDefaultValue(descriptor)));
            ++i;
        }
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return resource.getString("Name");
            }
            case 1: {
                return resource.getString("Type");
            }
            case 2: {
                return resource.getString("Default");
            }
            case 3: {
                return resource.getString("Current");
            }
            case 4: {
                return resource.getString(COMMENT_METHOD_SURFIX);
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 5;
    }

    public int getRowCount() {
        return this.descriptors.size();
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        PropertyDescriptor descriptor = (PropertyDescriptor)this.descriptors.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return descriptor.getName();
            }
            case 1: {
                return descriptor.getPropertyType();
            }
            case 2: {
                return this.getDefaultValue(descriptor);
            }
            case 3: {
                return this.editableValues.get(rowIndex).toString();
            }
            case 4: {
                return this.getComment(descriptor);
            }
        }
        return null;
    }

    public Class getColumnClass(int columnIndex) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public void update() {
        this.fireTableDataChanged();
    }

    public boolean isCellEditable(int row, int column) {
        logger.debug((Object)("isCellEditable:" + row + "-" + column));
        return column == 3;
    }

    public void setValueAt(Object value, int row, int col) {
        logger.debug((Object)("setValue:" + row + "-" + col + value.toString()));
        PropertyDescriptor descriptor = (PropertyDescriptor)this.descriptors.get(row);
        String type = descriptor.getPropertyType().getName();
        String value_str = (String)value;
        try {
            Object value_obj = this.parseObject(descriptor, value_str);
            if (value_obj != null) {
                this.editableValues.set(row, value_obj);
                this.fireTableCellUpdated(row, col);
            } else {
                logger.warn((Object)("This type is not editable.:" + value_obj));
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.comp, String.valueOf(resource.getString("Invalid")) + descriptor.getName());
        }
    }

    private Object parseObject(PropertyDescriptor descriptor, String value_str) {
        Constable value_obj = null;
        if (descriptor.getPropertyType().getName().equals("int")) {
            value_obj = new Integer(Integer.parseInt(value_str));
        } else if (descriptor.getPropertyType().getName().equals("long")) {
            value_obj = new Long(Long.parseLong(value_str));
        } else if (descriptor.getPropertyType().getName().equals("char") && value_str.toCharArray().length == 1) {
            value_obj = new Character(value_str.charAt(0));
        } else if (descriptor.getPropertyType().getName().equals("boolean")) {
            value_obj = Boolean.valueOf(value_str);
            logger.debug((Object)("boolean:" + value_str + "\u2192" + value_obj.toString()));
        } else if (descriptor.getPropertyType().getName().equals("short")) {
            value_obj = new Short(Short.parseShort(value_str));
        } else if (descriptor.getPropertyType().getName().equals("byte")) {
            value_obj = new Byte(Byte.parseByte(value_str));
        } else if (descriptor.getPropertyType().getName().equals("double")) {
            value_obj = new Double(Double.parseDouble(value_str));
        } else if (descriptor.getPropertyType().getName().equals("float")) {
            value_obj = new Float(Float.parseFloat(value_str));
        }
        return value_obj;
    }

    private String getCurrentValue(PropertyDescriptor descriptor) {
        return this.getPropertyValue(this.currentObject, descriptor);
    }

    private String getDefaultValue(PropertyDescriptor descriptor) {
        return this.getPropertyValue(this.defaultObject, descriptor);
    }

    private String getPropertyValue(Object source, PropertyDescriptor descriptor) {
        try {
            return descriptor.getReadMethod().invoke(source, null).toString();
        }
        catch (IllegalAccessException e) {
            logger.warn((Object)"getter is not accessable.", (Throwable)e);
            return "";
        }
        catch (InvocationTargetException e) {
            logger.warn((Object)"getter invocation failed.", (Throwable)e);
            return "";
        }
    }

    private String getComment(PropertyDescriptor descriptor) {
        try {
            String commentMethodName = String.valueOf(descriptor.getReadMethod().getName()) + COMMENT_METHOD_SURFIX;
            Method m = this.currentObject.getClass().getDeclaredMethod(commentMethodName, null);
            logger.debug((Object)commentMethodName);
            return m.invoke(this.currentObject, null).toString();
        }
        catch (NoSuchMethodException e) {
            return "";
        }
        catch (IllegalAccessException e) {
            return "";
        }
        catch (InvocationTargetException e) {
            return "";
        }
    }

    public List getNewValues() {
        return this.editableValues;
    }
}

