/*
 * BESPLauncher.java
 *
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;

import org.boxed_economy.besp.container.BESP;

/**
 * BESP̃vOCCXg[邽߂ɎsNXłB
 * C\bhŋN̈ƁAvOCfBNg̍\ɃNXpX
 * Xg쐬܂BāÃNXpX^BESPs܂B
 * ɂAvOCfBNgNXpXɒǉ܂B
 *
 * @author rx78g
 * @version $Id: BESPLauncher.java,v 1.1 2004/03/21 12:07:50 macchan Exp $
 */
public class BESPLauncher {

	public static final String PLUGINDIR = "plugins";
	public static final String CLASSPATH_SEPARATOR = File.pathSeparator;
	public static final String JAR_EXTENSION = ".jar";
	public static final String ZIP_EXTENSION = ".zip";
	public static final String OS_KEY = "os.name";

	public static final String OPTION_CLASSPATH = "-classpath";
	public static final String OPTION_PRINT = "-print";
	public static final String OPTION_BOXHOME = "-home";
	public static final String OPTION_LOGPROPERTYFILE = "-logbyfile";
	public static final String OPTION_LOG = "-log";
	public static final String OPTION_MODEL = "-model";
	public static final String OPTION_LOCALE = "-locale";
	public static final String OPTION_HELP = "-help";
	public static final String OPTION_DEBUG = "-debug";

	/**
	* C\bhłBBESP𐶐Ďs܂B
	* ̍ۂɕKݒt@Cǂݍނ߂̃pXn܂B
	* @param args N̈
	*/
	public static void main(String[] args) {
		BESPLauncher besp = new BESPLauncher();
		besp.launch(args);
	}

	private String boxHome = System.getProperty("user.dir");
	private String currentClasspath = System.getProperty("java.class.path");
	private Collection classpaths = new TreeSet(); //dȂŁA
	private Map argMap = new HashMap();
	private Process process = null;

	private void launch(String[] args) {
		try {

			//bZ[W
			String argStr = this.listToString(Arrays.asList(args), " ");
			System.out.println("BESPLauncer start .....................  ");
			System.out.println("args = " + argStr);

			//̏
			this.initializeArguments(args);
			this.showHelp(); //Ɂuhelpv܂܂Ăꍇ̏s܂B

			//			
			this.initializeBoxHome();
			this.initializeClasspath();

			//NāAvgXbh𗧂グ
			this.boot(args);
			if (this.isPrint()) {
				this.startPrintThread();
				this.waitForBESP();
			}

		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	/**
	 * p[^ǂݍŃnbVɊi[܂
	 */
	private void initializeArguments(String[] args) {
		for (int i = 0; i < args.length; i++) {
			if (args[i].startsWith("-")) {
				if (i + 1 < args.length) {
					this.argMap.put(args[i], args[i + 1]);
				} else {
					this.argMap.put(args[i], null);
				}
			}
		}
	}

	/**
	 * Ɂu-helpv܂܂ĂꍇAwvbZ[W\ďI܂B
	 */
	private void showHelp() {
		if (this.argMap.containsKey(BESPLauncher.OPTION_HELP)) {
			System.out.println("-HELP COMMENTS-");
			System.out.println("[-classpath] add JAVA-CLASSPATH entries.");
			System.out.println("[-help]      show this Help.");
			System.out.println(
				"[-home]      set Box Home Directory.(default is User Directory("
					+ System.getProperty("user.dir")
					+ ")");
			System.out.println(
				"[-locale]    set locale(define standard locale format. ex) ja_JP)");
			System.out.println(
				"[-logconf]   set Log Configulation file (default is Basic-Configulation log4j)");
			System.out.println(
				"[-model]     set First Load Model Class(By Class Name or .box File )");
			System.out.println(
				"[-print]     output texts.(Log ,Error,Information etc...)");

			System.exit(0);
		}
	}

	/**
	 * BOXz[fBNgݒ肵܂B
	 * w肵Ȃ΁AƃfBNgBOXz[ɂȂ܂B
	 */
	private void initializeBoxHome() {
		if (this.argMap.containsKey(BESPLauncher.OPTION_BOXHOME)) {
			this.boxHome =
				(String) this.argMap.get(BESPLauncher.OPTION_BOXHOME);
		}
	}

	/**
	 * vg[hɂ邩ǂ
	 * IvVŎw肳Ă邩ׂ܂
	 */
	private boolean isPrint() {
		return this.argMap.containsKey(OPTION_PRINT);
	}

	/**
	 * NXpX܂B
	 * Sēǂݍŉ͂AclasspathsXgɓĂ܂
	 */
	private void initializeClasspath() {
		this.searchClasspathFromDirectory(new File(boxHome, PLUGINDIR));
		this.searchClasspathFromArgument(currentClasspath);
		this.searchClasspathFromArgument(this.searchClasspathOption());
	}

	private void searchClasspathFromDirectory(File f) {
		if (f.isDirectory()) { //directory
			File[] fileList = f.listFiles();
			for (int i = 0; i < fileList.length; i++) {
				this.searchClasspathFromDirectory(fileList[i]); //recursion
			}
		} else { //file 
			String fileName = f.getName();
			if (fileName.endsWith(JAR_EXTENSION)
				|| fileName.endsWith(ZIP_EXTENSION)) {
				this.classpaths.add(f.getAbsoluteFile().toString());
			}
		}
	}

	private void searchClasspathFromArgument(String classpath) {
		StringTokenizer tokenizer =
			new StringTokenizer(classpath, CLASSPATH_SEPARATOR);
		while (tokenizer.hasMoreTokens()) {
			this.classpaths.add(tokenizer.nextToken());
		}
	}

	private String searchClasspathOption() {
		if (this.argMap.containsKey(OPTION_CLASSPATH)) {
			return (String) this.argMap.get(OPTION_CLASSPATH);
		}
		return "";
	}

	private String createClasspathString() {
		String classpath =
			this.listToString(
				new ArrayList(this.classpaths),
				CLASSPATH_SEPARATOR);

		//escape for space
		if (System.getProperty(OS_KEY).startsWith("Windows")) {
			classpath = "\"" + classpath + "\"";
		} else {
			StringBuffer buf = new StringBuffer();
			buf.append((char) Character.NON_SPACING_MARK);
			classpath = classpath.replaceAll(" ", buf.toString());
		}

		return classpath;
	}

	/**
	 * R}h𐶐܂
	 */
	private String createCommand(String[] args) {
		List commands = new ArrayList();
		commands.add(this.getJavaCommand());
		commands.add("-classpath");
		commands.add(this.createClasspathString());
		commands.add(BESP.class.getName());

		//ǉ
		for (int i = 0; i < args.length; i++) {
			commands.add(args[i]);
		}

		return this.listToString(commands, " ");
	}

	/**
	 * Xg؂ȂA1̕ɂȂ܂
	 */
	private String listToString(List list, String delim) {
		StringBuffer buf = new StringBuffer();
		int len = list.size();
		for (int i = 0; i < len; i++) {
			if (i != 0) {
				buf.append(delim);
			}
			buf.append(list.get(i));
		}
		return buf.toString();
	}

	/**
	 * BESP𗧂グ܂
	 */
	private void boot(String[] args) throws Exception {
		String command = this.createCommand(args);
		System.out.println("BESP booting by BESPLauncher command = " + command);
		this.process = Runtime.getRuntime().exec(command);
	}

	/**
	 * JavaR}h擾܂
	 * (OSWindowsȂjavawg܂)
	 */
	private String getJavaCommand() {
		if (System.getProperty(OS_KEY).startsWith("Windows")) {
			return "javaw";
		}
		return "java";
	}

	/**
	 * BESPI邩AI܂őҋ@܂
	 */
	private void waitForBESP() throws Exception {
		BESPLauncher.this.process.waitFor();
	}

	/**
	 * vgXbhJn܂
	 */
	private void startPrintThread() throws InterruptedException {
		//AEg
		PrintThread out = new PrintThread();
		out.input = this.process.getInputStream();
		out.output = System.out;
		out.start();

		//G[
		PrintThread err = new PrintThread();
		err.input = this.process.getErrorStream();
		err.output = System.err;
		err.start();
	}

	/**
	 * vgXbhłB
	 * 
	 * @author rx78g
	 * @version $Id: BESPLauncher.java,v 1.1 2004/03/21 12:07:50 macchan Exp $
	 */
	class PrintThread extends Thread {
		InputStream input;
		PrintStream output;
		public void run() {
			try {
				BufferedReader br =
					new BufferedReader(new InputStreamReader(input));
				String buf = "";
				while ((buf = br.readLine()) != null) {
					output.println(buf);
				}
			} catch (Exception ex) {
				ex.printStackTrace();
			}
		}
	}

}
