/*
 * ArgumentManager.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.container;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.BESPLauncher;

/**
 * BESPN̈ǗNXłB
 * 
 * @author macchan
 * @version $Id: ArgumentManager.java,v 1.2 2004/06/07 04:35:46 macchan Exp $
 */
public class ArgumentManager {

	private static final Logger logger =
		Logger.getLogger(ArgumentManager.class.getName());

	/**
	 * Look&FeelłB
	 */
	public static String lookAndFeel =
		"com.sun.java.swing.plaf.windows.WindowsLookAndFeel";

	/**
	 * LOCALEݒt@C̖Oł
	 */
	public static final String LOCALE_FILENAME = "besp.locale";

	/**
	 * LOG̐ݒłBftHgFileɂȂĂ܂
	 */
	public String logType = BESP.LOG_FILE;

	/**
	 * LOG̐ݒt@CłBftHgnullɂȂĂ܂B
	 */
	public String logPropertyFileName = null;

	/**
	 * ŏɓǂݍ܂郂fłB
	 */
	public String modelName = null;

	/**
	 * ^ꂽǂݍŃnbVɊi[Aeڂ̃`FbNs܂B
	 * ڂ݂Ȃ΃ftHg̒lݒ肵܂B
	 */
	public void initializeArguments(String[] args) {
		try {
			Map argMap = new HashMap();

			for (int i = 0; i < args.length; i++) {
				if (args[i].startsWith("-")) {
					if (i + 1 < args.length) {
						argMap.put(args[i], args[i + 1]);
					} else {
						argMap.put(args[i], null);
					}
				}
			}

			//BOXz[fBNg擾܂B
			//w肵Ȃ΁AƃfBNgBOXz[ɂȂ܂B
			if (argMap.containsKey(BESPLauncher.OPTION_BOXHOME)) {
				BESP.boxHome = (String) argMap.get(BESPLauncher.OPTION_BOXHOME);
			}

			//Õ^Cv擾܂
			if (argMap.containsKey(BESPLauncher.OPTION_LOG)) {
				this.logType = (String) argMap.get(BESPLauncher.OPTION_LOG);
			}
			//Ot@CŎw肳ꂽꍇ́At@Cݒ肵AÕ^CvpropertyfileɂȂ܂
			if (argMap.containsKey(BESPLauncher.OPTION_LOGPROPERTYFILE)) {
				this.logPropertyFileName =
					(String) argMap.get(BESPLauncher.OPTION_LOGPROPERTYFILE);
				this.logType = BESP.LOG_PROPERTYFILE;
			}

			//ŏɊJf̃NX邢̓t@Cw肵܂B
			if (argMap.containsKey(BESPLauncher.OPTION_MODEL)) {
				this.modelName = (String) argMap.get(BESPLauncher.OPTION_MODEL);
			}

			//P[ݒ肵܂B	
			initializeLocale(argMap);

			//DEBUGtOݒ肵܂
			if (argMap.containsKey(BESPLauncher.OPTION_DEBUG)) {
				BESP.DEBUG = true;
			}

		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	/**
	 * P[̗D揇́@->vpeBt@C->ftHgiOSj̏ł
	 */
	private void initializeLocale(Map argMap) {

		//		
		if (argMap.containsKey(BESPLauncher.OPTION_LOCALE)) {
			Locale.setDefault(
				new Locale((String) argMap.get(BESPLauncher.OPTION_LOCALE)));
		}
		//vpeBt@C
		else {
			try {
				File file = new File(BESP.boxHome, LOCALE_FILENAME);
				if (file.exists()) {
					BufferedReader br =
						new BufferedReader(new FileReader(file));
					String line = br.readLine();
					Locale.setDefault(new Locale(line));
				}
			} catch (Exception ex) {
				ex.printStackTrace();
			}
		}
	}

	public void log() {
		logger.info("BoxHome = " + BESP.boxHome);
		logger.info("LogType = " + this.logType);
		logger.info("LogPropertyName = " + this.logPropertyFileName);
		logger.info("ModelName = " + this.modelName);
		logger.info("Locale = " + Locale.getDefault());
	}

}
