/*
 * BESP.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.container;

import java.io.File;
import java.util.ResourceBundle;

import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.boxed_economy.besp.container.classtree.BoxClassTreeCreator;
import org.boxed_economy.besp.container.classtree.BoxRootPackage;
import org
	.boxed_economy
	.besp
	.container
	.classtree
	.CleaningInvalidClassBoxClassTreeVisitor;
import org.boxed_economy.besp.container.command.Command;
import org.boxed_economy.besp.container.command.FileOpenCommand;
import org.boxed_economy.besp.container.command.ImportWorldCommand;

/**
 * BESP̃CNXłBQcontainerzuABESPAvP[V̏𒆐SIɍs܂B
 * NXpXBESPLauncher^ċN܂B̃NX̂̂N邱Ƃł܂
 * ȀꍇNXpX̂Pluginǂݍ܂邱ƂȂs܂B
 * 
 * @author rx78g
 * @version $Id: BESP.java,v 1.4 2004/06/07 04:35:46 macchan Exp $
 */
public class BESP {

	private static final Logger logger = Logger.getLogger(BESP.class.getName());

	/********
	 * 萔
	 ********/
	public static final String EXTENSION = ".box";

	public static final String VERSION = "v1.2.2 (build 2004/06/07)";
	public static final String COPYRIGHT =
		"Copyright(c) 2000-2004 Boxed Economy Project";

	public static final String LOG_CONSOLE = "console";
	public static final String LOG_FILE = "file";
	public static final String LOG_GUI = "gui";
	public static final String LOG_PROPERTYFILE = "propertyfile";

	/********
	 * field
	 ********/

	/**
	 * initalizẽbZ[W؂ւ邽߂̃\[Xݒ肵܂B
	 * defaultenglishɐݒ肵܂B
	 */
	public static ResourceBundle resource = null;

	/**
	 * BOXz[fBNgłBftHgōƃfBNgw肵܂B
	 */
	public static String boxHome = System.getProperty("user.dir");

	/**
	* BESPsɗpĂNXc[̃[gNXłB
	* vOC̃[hȂǂɎgp܂B
	*/
	public static BoxRootPackage classTreeRoot = null;

	/**
	* BESPɐݒ肳ĂcontainerłB
	*/
	public static BESPContainer container = null;

	/**
	 * ǗNXł
	 */
	public static ArgumentManager argument = null;

	/**
	 * vpeBǗNXł
	 */
	public static PropertyManager property = null;

	/**
	 * DEBUGtOł
	 */
	public static boolean DEBUG = false;

	/**
	 * Main\bhłBBESPvZXƂċN܂B
	 */
	public static void main(String[] args) {
		try {
			initializeArguments(args);
			initialize();
			loadFirstModel(argument.modelName);
		} catch (Exception ex) {
			logger.warn("initalize failed", ex);
			ex.printStackTrace();
			terminate();
		}
	}

	/**
	 * ܂
	 */
	private static void initializeArguments(String[] args) {
		argument = new ArgumentManager();
		argument.initializeArguments(args);
	}

	/**
	* SĂ̏sȂ܂B
	*/
	private static void initialize() throws Exception {

		initializeResource();
		initializeLog();
		message();

		container = createContainer();
		container.getPresentationContainer().showTitle();

		container.getPresentationContainer().setInitialStatusMessage(
			resource.getString("initializeProperty"));
		initializeProperty();

		container.getPresentationContainer().setInitialStatusMessage(
			resource.getString("initializeClassTree"));
		initializeClassTree();

		container.getPresentationContainer().setInitialStatusMessage(
			resource.getString("initializeContainer"));
		initializeContainer();

		container.getPresentationContainer().hideTitle();
	}

	/**
	 * I܂B
	 */
	public static void terminate() {
		if (container != null) {
			container.terminate();
		}
		if (property != null) {
			property.save();
		}
		System.exit(0);
	}

	/**
	 * A܂
	 */
	private static void message() {
		logger.info("Hello! Boxed Economy Simulation Platform(BESP)");
		argument.log();
	}

	/**
	 * P[ݒ܂B
	 * OS̃ftHgP[ɊÂResouceBundleǂݍ܂܂
	 */
	private static void initializeResource() {
		resource = ResourceBundle.getBundle(BESPResource.class.getName());
	}

	/**
	 * O̐ݒ܂B
	 * ݒt@Cw肳Ă΁Aǂݍ݁Aw肳ĂȂΊ{ݒ
	 * ܂B
	 */
	public static void initializeLog() throws Exception {
		try {
			if (argument.logType.equals(BESP.LOG_PROPERTYFILE)) {
				PropertyConfigurator.configure(argument.logPropertyFileName);
				logger.info(
					"Log Initialized by PropertyFile = "
						+ argument.logPropertyFileName);
			} else {
				PropertyConfigurator.configure(
					BESP.class.getResource(
						"log4j." + argument.logType + ".properties"));
				logger.info("Log Initialized by " + argument.logType);
			}
		} catch (Exception ex) {
			//OoꍇAG[fďI
			throw ex;
		}
	}

	/**
	 * Rei𐶐܂
	 */
	private static BESPContainer createContainer() throws Exception {
		return new BESPContainer();
	}

	/**
	 * vpeB܂B
	 */
	private static void initializeProperty() {
		property = new PropertyManager();
		property.load();
	}

	/**
	 * NXc[܂B
	 * NXpXSẴNXǂݍ݁ANXc[\zāAŏʂ
	 * vfێ܂B
	 */
	private static void initializeClassTree() {
		//c[\
		BoxClassTreeCreator creator = new BoxClassTreeCreator();
		classTreeRoot = creator.createFromClassPath();
		//ȂNXr
		CleaningInvalidClassBoxClassTreeVisitor cleaner =
			new CleaningInvalidClassBoxClassTreeVisitor();
		cleaner.treewalk(classTreeRoot);
	}

	/**
	 * Rei܂B
	 */
	private static void initializeContainer() throws Exception {
		container.initialize();
	}

	/**
	 * ŏ̃f[h鏈łB
	 * @param modelName
	 */
	private static void loadFirstModel(String firstModel)
		throws Exception { //ŏ̃fݒ肳ĂȂ΁Â܂܏I܂B
		if (firstModel == null || firstModel.length() == 0) {
			return;
		} //t@CƃNXɉĎsR}hς܂B
		Command com = null;
		if (firstModel.endsWith(BESP.EXTENSION)) { //t@C̏ꍇ
			com = new FileOpenCommand(container, new File(firstModel));
		} else { //NX̏ꍇ
			com = new ImportWorldCommand(container, firstModel);
		}
		com.execute();
	}

}