/*
 * BESPContainer.java
 *
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.container;

import org.boxed_economy.besp.model.ModelContainer;
import org.boxed_economy.besp.presentation.PresentationContainer;

/**
 * BESP̑SẴR|[lgvOReiNX
 * v[e[VReiƃfRei\
 * vOCǗ@\
 * 
 * @author rx78g
 * @version $Id: BESPContainer.java,v 1.1 2004/03/21 12:07:48 macchan Exp $
 */
public class BESPContainer {

	/**
	 * ModelContainerłB
	 */
	private ModelContainer modelContainer = null;

	/**
	 * PresentationContainerłB
	 */
	private PresentationContainer presentationContainer = null;

	/**
	 * vOCǗNXł
	 */
	private PluginManager pluginManager = null;

	/**
	 * Constructor for BESPContainer.
	 */
	public BESPContainer() {
		super();
	}

	/*************
	 * , I
	 *************/

	/**
	 * Rei܂
	 */
	public void initialize() throws Exception {
		//fReȉ
		this.getModelContainer().initialize();

		//v[Reȉ
		this.getPresentationContainer().initialize();

		//vOC̓ǂݍ
		this.getPresentationContainer().setInitialStatusMessage(
			BESP.resource.getString("loadPlugin"));
		this.getPluginManager().loadPlugin();

		this.getPresentationContainer().getMainFrame().show();
	}

	/**
	 * ReiI܂
	 */
	public void terminate() {
		//vOC̏I
		this.getPluginManager().terminatePlugins();

		//v[ReȉI
		this.getPresentationContainer().terminate();

		//fReȉI
		this.getModelContainer().terminate();
	}

	/**************
	 * Rei̎擾
	 **************/

	/**
	* ModelContainerԂ܂B
	* @return modelContainer
	*/
	public ModelContainer getModelContainer() {
		if (this.modelContainer == null) {
			this.modelContainer = new ModelContainer(this);
		}
		return this.modelContainer;
	}

	/**
	* PresentationContainerԂ܂B
	* @return presentationContainer
	*/
	public PresentationContainer getPresentationContainer() {
		if (this.presentationContainer == null) {
			this.presentationContainer = new PresentationContainer(this);
		}
		return this.presentationContainer;
	}

	/**
	 * Returns the pluginManager.
	 * @return PluginManager
	 */
	public PluginManager getPluginManager() {
		if (this.pluginManager == null) {
			this.pluginManager = new PluginManager(this);
		}
		return pluginManager;
	}

}