/*
 * PluginManager.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.container;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;

/**
 * vOC̊ǗsNXłB
 * 
 * @author macchan
 * @version $Id: PluginManager.java,v 1.1 2004/03/21 12:07:48 macchan Exp $
 */
public class PluginManager {

	/****************************
	 * static
	 ****************************/

	private static final Logger logger =
		Logger.getLogger(PluginManager.class.getName());
	private static final Object[] VOID = new Object[0];

	/****************************
	 * field
	 ****************************/

	private List plugins = new ArrayList();
	private BESPContainer container = null;

	/****************************
	 * RXgN^
	 ****************************/

	/**
	 * Constructor for PluginManager.
	 */
	public PluginManager(BESPContainer container) {
		this.container = container;
	}

	/*************************************
	 * J
	 *************************************/

	/**
	 * Returns the plugins.
	 * @return List
	 */
	public List getPlugins() {
		return plugins;
	}

	/**
	 * vOCǂݍ݁A܂B
	 * (BESPPluginC^[tF[XpNX܂)
	 */
	void loadPlugin() {
		logger.debug("plugin loading start");

		//܂
		List pluginClasses = this.searchPluginClasses();

		//ˑMap쐬܂
		Map dependentMap = this.createDependentMap(pluginClasses);

		//ˑɕבւ܂
		this.orderByDependency(pluginClasses, dependentMap);

		//܂
		this.initializePlugins(pluginClasses, dependentMap);

		logger.debug(
			"plugin loading completed PluginClassesCount=" + this.plugins.size());
	}

	/**
	 * ǂݍ܂ĂvOCSĂI܂
	 */
	void terminatePlugins() {
		//XgRs[܂
		List tmp = new ArrayList(this.plugins);

		//tˑɕёւ܂
		Collections.reverse(tmp);

		//I܂
		this.terminatePlugins(tmp);
	}

	/*************************************
	 * vOC֘A
	 *************************************/

	/**
	 * PluginNXT܂B
	 */
	private List searchPluginClasses() {
		Class target = BESPPlugin.class;
		List classes = new ArrayList(BESP.classTreeRoot.getFilteredClasses(target));
		classes.remove(target); //BESPPluging͔

		//NX\(Ăǂ)
		Iterator i = classes.iterator();
		while (i.hasNext()) {
			Class pluginClass = (Class) i.next();
			logger.info("found plugin class = " + pluginClass.getName());
		}
		return classes;
	}

	/**
	 * PluginNX܂
	 */
	private void initializePlugins(List pluginClasses, Map dependentMap) {
		//ꂼ̃vOC܂
		Iterator i = pluginClasses.iterator();
		while (i.hasNext()) {
			Class pluginClass = (Class) i.next();
			if (!this.isInitializable(pluginClass, dependentMap)) {
				logger.warn(
					"cannot initialize plugin for dependency : " + pluginClass.getName());
				continue;

			}
			else if (this.plugins.contains(pluginClass)) {
				//ɏĂ
				logger.debug("already initialized : " + pluginClass.getName());
				continue;
			}
			else {
				this.initializePlugin(pluginClass);
			}
		}
	}

	/**
	 * vOC܂
	 * (initializePlugin\bhs,Xgɉ܂)
	 */
	private void initializePlugin(Class pluginClass) {
		try {
			this.invokeStaticMethod(
				pluginClass,
				BESPPlugin.INITIALIZEPLUGIN_METHOD_NAME,
				new Object[] { this.container });
			this.plugins.add(pluginClass);
		}
		catch (Exception ex) {
			logger.warn(
				"Exception in initializePlugin : pluginClass = "
					+ pluginClass.getName(),
				ex);
		}
	}

	/*************************************
	 * ˑ֘A
	 *************************************/

	/**
	 * [vOC:ˑNX]Map쐬܂
	 */
	private Map createDependentMap(List pluginClasses) {
		Map map = new LinkedHashMap();
		Iterator i = pluginClasses.iterator();
		while (i.hasNext()) {
			Class pluginClass = (Class) i.next();
			map.put(pluginClass, this.getDependentClasses(pluginClass));
		}
		return map;
	}

	/**
	 * ˑNXT܂
	 */
	private List getDependentClasses(Class pluginClass) {
		try {
			Object dependentClasses =
				this.invokeStaticMethod(
					pluginClass,
					BESPPlugin.GETDEPENDENTCLASSES_METHOD_NAME,
					VOID);
			if (dependentClasses == null || !(dependentClasses instanceof Class[])) {
				return Collections.EMPTY_LIST;
			}

			//PluginNXł邩`FbN			
			Class[] classes = (Class[]) dependentClasses;
			List list = new ArrayList();
			for (int i = 0; i < classes.length; i++) {
				if (!BESPPlugin.class.isAssignableFrom(classes[i])) {
					logger.warn(
						"dependentClass is not BESPPlugin plugin : "
							+ pluginClass.getName()
							+ " class : "
							+ classes[i].getName());
					continue;
				}
				list.add(classes[i]);
			}
			return list;
		}
		catch (Exception ex) {
			logger.warn(
				"Exception in getDependentClasses : pluginClass = "
					+ pluginClass.getName(),
				ex);
			return Collections.EMPTY_LIST;
		}
	}

	/**
	 * ˑ֌W猩āA\ǂԂ܂
	 */
	private boolean isInitializable(Class pluginClass, Map dependentMap) {
		List dependentClasses = (List) dependentMap.get(pluginClass);
		Iterator i = dependentClasses.iterator();
		while (i.hasNext()) {
			Class dependentClass = (Class) i.next();
			if (!this.plugins.contains(dependentClass)) {
				return false;
				//ˑNXĂȂ
			}
		}
		return true;
	}

	/**
	 * ˑ֌W𒲂ׁAˑ֌Wɕבւ܂
	 */
	private void orderByDependency(List pluginClasses, Map dependentMap) {
		List tmp = new ArrayList(pluginClasses);

		//ClassIuWFNg̐,PluginClassIuWFNg𐶐
		Iterator i = tmp.iterator();
		while (i.hasNext()) {
			Class clazz = (Class) i.next();
			PluginClass pluginClass = this.getPluginClass(clazz); //

			//ˑNX̎qIuWFNgƂēo^
			List dependentClasses = (List) dependentMap.get(pluginClass.clazz);
			Iterator j = dependentClasses.iterator();
			while (j.hasNext()) {
				Class dependentClass = (Class) j.next();
				this.getPluginClass(dependentClass).add(pluginClass);
			}
		}

		//PluginClassqGL[ˑ֌Wo
		//ёւs
		pluginClasses.clear();
		Iterator k = this.pluginClassMap.values().iterator();
		while (k.hasNext()) {
			PluginClass pluginClass = (PluginClass) k.next();
			if (pluginClass.parents.isEmpty()) {
				pluginClasses.addAll(pluginClass.getChildrenAsClass());
			}
		}

	}

	/**
	 * Atarget̕dependentɂ΁A
	 * dependenťtargetړ܂
	 */
	private void order(List pluginClasses, Object target, Object dependent) {
		int targetIndex = pluginClasses.indexOf(target);
		int dependentIndex = pluginClasses.indexOf(dependent);
		if (targetIndex < dependentIndex) {
			logger.debug("order target = " + target + " dependent=" + dependent);
			pluginClasses.remove(target);
			pluginClasses.add(dependentIndex, target);
		}
	}

	/*************************************
	 * I
	 *************************************/

	/**
	 * PluginNXQI܂
	 */
	private void terminatePlugins(List pluginClasses) {
		//ꂼ̃vOCI܂
		Iterator i = pluginClasses.iterator();
		while (i.hasNext()) {
			Class pluginClass = (Class) i.next();
			this.terminatePlugin(pluginClass);
		}
	}

	/**
	 * vOCI܂
	 * (terminatePlugin\bhs,Xg폜܂)
	 */
	private void terminatePlugin(Class pluginClass) {
		try {
			this.invokeStaticMethod(
				pluginClass,
				BESPPlugin.TERMINATEPLUGIN_METHOD_NAME,
				new Object[] { this.container });
		}
		catch (Exception ex) {
			logger.warn(
				"Exception in terminatePlugin : pluginClass = " + pluginClass.getName(),
				ex);
		}
		finally {
			this.plugins.remove(pluginClass);
		}
	}

	/*************************************
	 * static\bhReflectionŎs֘A
	 *************************************/

	/**
	 * ^̂static\bhTāAs܂
	 */
	private Object invokeStaticMethod(
		Class clazz,
		String methodName,
		Object[] parameters)
		throws Exception {

		Method method = this.searchStaticMethod(clazz, methodName, parameters);
		if (method != null) {
			logger.info("\"" + method.getName() + "\" found in = " + clazz.getName());
			return method.invoke(null, parameters);
		}
		else {
			return null;
		}
	}

	/**
	 * ^}b`郁\bhT܂
	 */
	private Method searchStaticMethod(
		Class clazz,
		String methodName,
		Object[] parameters) {
		Method[] methods = clazz.getMethods();
		for (int i = 0; i < methods.length; i++) {
			Method method = methods[i];
			if (method.getName().equals(methodName)
				&& this.equalsParameter(method.getParameterTypes(), parameters)
				&& Modifier.isStatic(method.getModifiers())) {
				return method;
			}
		}
		return null;
	}

	/**
	 * p[^^CvǂԂ܂
	 */
	private boolean equalsParameter(
		Class[] parameterTypes,
		Object[] parameters) {
		if (parameterTypes.length != parameters.length) {
			return false;
		}
		for (int i = 0; i < parameterTypes.length; i++) {
			if (!parameterTypes[i].isInstance(parameters[i])) {
				return false;
			}
		}
		return true;
	}

	/*************************************
	 * Class:ˑ֌WNX
	 *************************************/
	private Map pluginClassMap = new HashMap();

	private PluginClass getPluginClass(Class clazz) {
		if (this.pluginClassMap.containsKey(clazz)) { //ɂ
			return (PluginClass) this.pluginClassMap.get(clazz);
		}
		else { //ȂꍇAVK쐬
			PluginClass pluginClass = new PluginClass();
			pluginClass.clazz = clazz;
			this.pluginClassMap.put(clazz, pluginClass);
			return pluginClass;
		}
	}

	class PluginClass {
		Class clazz = null;
		List parents = new ArrayList();
		List children = new ArrayList(); //PluginClass

		public void add(PluginClass child) {
			if (this.getParents().contains(child)) {
				logger.warn("cannot load for cycle plugin : " + child.clazz);
				return;
			}
			child.parents.add(this);
			this.children.add(child);
		}

		public List getParents() {
			List list = new ArrayList();
			list.add(this);
			Iterator i = this.parents.iterator();
			while (i.hasNext()) {
				PluginClass element = (PluginClass) i.next();
				list.addAll(element.getParents());
			}
			return list;
		}

		public List getChildrenAsClass() {
			List list = new ArrayList();
			list.add(this.clazz);
			Iterator i = children.iterator();
			while (i.hasNext()) {
				PluginClass child = (PluginClass) i.next();
				list.addAll(child.getChildrenAsClass());
			}
			return list;
		}
		public boolean Equals(Object o) {
			return ((PluginClass) o).clazz == this.clazz;
		}
	}

}
