/*
 * PropertyManager.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.container;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.apache.log4j.Logger;

/**
 * vpeBǗNX
 * vpeBMap`ŊǗ܂
 * vpeBBESPIɕۑ܂(VACY܂)
 * @author macchan
 * @version $Id: PropertyManager.java,v 1.1 2004/03/21 12:07:48 macchan Exp $
 */
public class PropertyManager {

	private static final Logger logger =
		Logger.getLogger(PropertyManager.class.getName());

	private static final String FILENAME = ".properties";

	private Map properties = new HashMap();

	/**
	 * Constructor for PropertyManager.
	 */
	public PropertyManager() {
		super();
	}

	/***********************
	 * ǉA擾
	 ***********************/

	public void put(Class clazz, Serializable property) {
		this.properties.put(clazz.getName(), property);
	}

	public Object get(Class clazz) {
		return this.properties.get(clazz.getName());
	}

	/*****************************************************************
	 * [hAZ[u
	 * EntryĂĂvȂ悤Map̃VACYOĂ܂
	 *****************************************************************/

	void load() {
		try {

			//O
			ObjectInputStream stream =
				new ObjectInputStream(new FileInputStream(this.getFile()));

			//{iǂݍ݁j
			int size = stream.readInt();
			for (int i = 0; i < size; i++) {
				try {
					Entry entry = (Entry) stream.readObject();
					this.properties.put(entry.key, entry.value);
				}
				catch (Exception ex) {
					logger.warn("the property is broken", ex);
				}
			}

			//㏈
			stream.close();
		}
		catch (FileNotFoundException ex) {
			logger.info("properties file not found , creating new one");
			this.properties = new HashMap();
		}
		catch (Exception ex) {
			logger.warn("properties file is broken , creating new one", ex);
			this.properties = new HashMap();
		}
	}

	void save() {
		try {

			//O
			ObjectOutputStream stream =
				new ObjectOutputStream(new FileOutputStream(this.getFile()));

			//{i݁j
			Set entrySet = this.properties.entrySet();
			stream.writeInt(entrySet.size());

			Iterator i = entrySet.iterator();
			while (i.hasNext()) {
				Map.Entry mapEntry = (Map.Entry) i.next();
				try {
					Entry entry = new Entry();
					entry.key = mapEntry.getKey();
					entry.value = mapEntry.getValue();
					stream.writeObject(entry);
				}
				catch (Exception ex) {
					logger.warn(
						"the property " + mapEntry.getKey() + "is cannot save because = ",
						ex);
				}
			}

			//㏈
			stream.close();
		}
		catch (Exception ex) {
			logger.warn("properties file cannot save because = ", ex);
		}
	}

	private File getFile() {
		return new File(BESP.boxHome + File.separator + FILENAME);
	}

}

class Entry implements Serializable {
	Object key = null;
	Object value = null;
}
