/*
 * BoxClassTreeCreator.java
 *
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.container.classtree;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.BESPLauncher;

/**
 * BESPNXc[𐶐NXłBNXpXfBNgJARt@C擾
 * ăNX̗vfXg\AgăNXc[Ƃč\܂B
 * āABESPNXc[̃[gvfԂ܂B
 * 
 * @author rx78g
 * @version $Id: BoxClassTreeCreator.java,v 1.1 2004/03/21 12:07:49 macchan Exp $
 */
public class BoxClassTreeCreator {

	private static final Logger logger =
		Logger.getLogger(BoxClassTreeCreator.class.getName());

	private static final String ROOT = ".";
	private static final String DELIMITER = "/";
	private static final String ZIP_EXTENTION = ".zip/";
	private static final String JAR_EXTENTION = ".jar";

	/**
	* createɕԂclassTreeRootłB
	*/
	private BoxRootPackage root;

	//creatê߈ꎞIɎgtB[h
	private ArrayList elements;
	private ArrayList pluginElements;
	private HashMap elementsMap;
	private Stack packageNameStack;
	private ArrayList pluginClassNames;

	/**
	* createBoxClassTreê߂̏sȂ܂B
	* ꎞIɎgVectorAX^bN܂B
	*/
	private void initialize() {
		this.elements = new ArrayList();
		this.pluginElements = new ArrayList();
		this.elementsMap = new HashMap();
		this.packageNameStack = new Stack();
		this.pluginClassNames = new ArrayList();

		//rootݒ肵܂B
		this.root = new BoxRootPackage(ROOT);
		this.elementsMap.put(ROOT, root);
	}

	/**
	* NXpX𑖍ăNXc[\A[gpbP[WԂ܂B
	* 
	* @return classTreeRoot
	*/
	public BoxRootPackage createFromClassPath() {
		String allClassPath = System.getProperty("java.class.path");

		logger.debug("start creating classtree (classpath=" + allClassPath + ")");

		try {
			//ꎞIɎgtB[h܂B
			this.initialize();

			//classPathvfƂɐ؂o܂B
			String[] classPaths = this.divideClassPath(allClassPath);

			//elmList𐶐܂B
			this.addElementFromFilePaths(classPaths);

			//className\[g܂B
			Collections.sort(elements);
			Collections.reverse(elements);

			//elmListAc[𐶐܂B
			createBoxClassTreeFromElmList();

		}
		catch (Exception ex) {
			logger.warn("exception occured !", ex);
		}

		return root;
	}

	/**
	* JARURL𐶐܂B
	* 
	* @param path URLƂĐݒ肷pX
	* @param entry className
	* @return ꂽURL
	*/
	private URL createJarURL(String path, String entry) throws Exception {
		return new URL("jar:" + new File(path).toURL() + "!/" + entry);
	}

	/**
	 * NX̔z񂩂ANXc[𐶐A[gvfԂ܂B
	 * 
	 * @param classArray NXc[𐶐NẌꗗ
	 */
	public BoxClassTreeElement createFromClassArray(Class[] classArray) {
		logger.debug("start creating class tree");

		try {
			//ꎞIɎgtB[hinitalize܂B
			this.initialize();

			//elmList𐶐܂B
			this.createElementFromClassArray(classArray);

			//className\[g܂B
			Collections.sort(elements);
			Collections.reverse(elements);

			//elmListAc[𐶐܂B
			createBoxClassTreeFromElmList();

		}
		catch (Exception ex) {
			logger.warn("exception caught in creating classtree", ex);
		}

		logger.debug("creating class tree completed");
		return this.root;
	}

	// --------------ȉTu\bh---------------

	/**
	* classPathZ~R؂̗vfget܂B
	*/
	private String[] divideClassPath(String classPathStr) {
		//Z~R؂Ŏw肳Ă镔getAԂɓǂݍ݂܂B
		StringTokenizer st =
			new StringTokenizer(
				classPathStr,
				BESPLauncher.CLASSPATH_SEPARATOR,
				false);
		String[] trimedArray = new String[st.countTokens()];
		for (int i = 0; i < trimedArray.length; i++) {
			trimedArray[i] = st.nextToken();
		}
		return trimedArray;
	}

	/**
	* createElmListFromClassArray(){
	*/
	private void createElementFromClassArray(Class[] classArray) {
		for (int i = 0; i < classArray.length; i++) {
			String className = classArray[i].getName();
			StringTokenizer tokenizer = new StringTokenizer(className, ".");
			String elmPathName = "";
			int len = tokenizer.countTokens();
			for (int j = 0; j < len; j++) {
				elmPathName = elmPathName + DELIMITER + tokenizer.nextToken();
			}
			//ԕinsert
			elements.add(ROOT + elmPathName);
		}
	}

	private void addElementFromFilePaths(String[] filePaths) throws Exception {
		for (int i = 0; i < filePaths.length; i++) {
			this.addElementFromFilePath(filePaths[i]);
		}
	}

	private void addElementFromFilePath(String filePath) throws Exception {
		File file = new File(filePath);
		if (!file.exists()) {
			logger.warn("file isn't exist (" + file.getName() + ")");
			return;
		}

		if (file.getName().toLowerCase().endsWith(JAR_EXTENTION)
			|| file.getName().toLowerCase().endsWith(ZIP_EXTENTION)) {
			//JARZIPt@CłꍇJARvfǂݍ݃\bhĂт܂B
			JarFile jarfile = new JarFile(file);
			this.addElementFromJar(jarfile);
		}
		else if (file.isDirectory()) {
			//fBNgłꍇfBNgvfǂݍ݃\bhĂт܂B
			this.addElementFromDir(file, true);
		}
		else {
			logger.warn("unknown file = " + file.getName());
		}
	}

	/**
	 * fBNgɂJARt@C̃pXTāAzԂ܂B
	 */
	private String[] getJarfilePathsFromDir(String dirName) throws Exception {
		ArrayList jarfilePaths = new ArrayList();
		File f = new File(dirName);
		if (!f.isDirectory()) {
			logger.warn("directory isn't exist" + f.getPath());
			return new String[0];
		}
		File[] files = f.listFiles();
		for (int i = 0; i < files.length; i++) {
			if (files[i].isFile()
				&& files[i].getAbsolutePath().endsWith(JAR_EXTENTION)) {
				jarfilePaths.add(files[i]);
			}
		}
		String[] strs = new String[jarfilePaths.size()];
		for (int i = 0; i < jarfilePaths.size(); i++) {
			strs[i] = ((File) jarfilePaths.get(i)).getAbsolutePath();
		}
		return strs;
	}

	/**
	* Jart@C̃Gg[ǂݍelmListaddĂ܂B
	* JARGgclassName\LɕϊelmListɒǉ܂B
	* eXĝ߁ApublicɂĂ܂B
	*/
	private void addElementFromJar(JarFile jarfile) throws Exception {
		Enumeration e = jarfile.entries();
		while (e.hasMoreElements()) {
			JarEntry JAREntry = (JarEntry) e.nextElement();

			//fBNgadd܂B
			if (JAREntry.isDirectory()) {
				continue;
			}

			String JARPath = JAREntry.getName();
			//NXłȂadd܂B
			if (!this.isClass(JARPath)) {
				continue;
			}

			//elmListclassNameɕϊꂽJARGgpXǉ܂B
			String convertedPath = convertJarEntryPath(JARPath);
			elements.add(convertedPath);

		}
	}

	/**
	* pX݂āANXt@Cǂ肵܂B
	* ł́AŌオ.classł邱Ƃ𔻒肵܂B
	*/
	private boolean isClass(String str) {
		return str.endsWith(".class");
	}

	/**
	* JARGg̕\LclassPathȉ.؂̃pXɒu܂B
	* JARGg.classł邱Ƃ͕ۏ؍ς݂Ƃ܂B
	* (com/ibm/test.class  ./com/ibm/test)
	*/
	private String convertJarEntryPath(String jarpath) {
		String str = trimClassExtention(jarpath);
		str = ROOT + DELIMITER + str;
		return str;
	}

	/**
	* elmMapadd
	*
	* t@C珇Ԃɓǂ݂elmMapaddĂ܂B
	* DirectoryNamepackageNameStackɒ߂ȂċAIɌĂяo܂B
	*/
	private void addElementFromDir(File targetDirectory, boolean isRoot) {
		logger.debug(
			"BoxClassTreeCreator#addToElmMapFromDir " + targetDirectory.toString());
		//rootłȂ΁ApackageNameX^bNɐς݂܂B
		if (!isRoot) {
			packageNameStack.push(targetDirectory.getName());
		}

		File[] fileElm = targetDirectory.listFiles();

		for (int i = 0; i < fileElm.length; i++) {
			if (fileElm[i].isDirectory()) {
				//fBNgł΁AċAIɌĂяo܂B
				addElementFromDir(fileElm[i], false);
			}
			else {
				//t@Cł΁A
				String fileName = fileElm[i].getName();
				//NXłȂadd܂B
				if (!this.isClass(fileName)) {
					continue;
				}
				//fileName
				String elmName = convertFilePath(fileName);
				elements.add(elmName);
			}
		}

		//rootłȂ΁ApackageNameX^bN牺낵܂B
		if (!isRoot) {
			packageNameStack.pop();
		}
	}

	/**
	* NX̊gq؂܂B
	*/
	private String trimClassExtention(String target) {
		return target.substring(0, target.lastIndexOf(".class"));
	}

	/**
	* ΃pXt@C\LclassPathȉ.؂̃pXɒu܂B
	* (test.class  ./com/numeric/test)
	* t@C.class ł邱ƂOƂĂ܂B
	*/
	private String convertFilePath(String fileName) {
		String convertStr = trimClassExtention(fileName);

		String createStr = ROOT;
		Stack tmpStack = new Stack();

		//X^bNtɂ
		int len = packageNameStack.size();
		for (int i = 0; i < len; i++) {
			String packageName = (String) packageNameStack.pop();
			tmpStack.push(packageName);
		}

		//X^bN߂ApX𐶐
		for (int i = 0; i < len; i++) {
			String packageName = (String) tmpStack.pop();
			createStr = createStr + DELIMITER + packageName;
			packageNameStack.push(packageName);
		}

		createStr = createStr + DELIMITER + convertStr;
		return createStr;
	}

	/**
	* c[vfꗗ𑖍boxClassTreevfaddĂArootpbP[WԂ܂B
	*/
	private void createBoxClassTreeFromElmList() {
		Iterator ite = elements.iterator();
		while (ite.hasNext()) {
			addTreeElm((String) ite.next(), false);
		}
	}

	/**
	* c[vfpX^ǂݍŗvfԂ܂B
	* ȂΐVKboxClassTreevf𐶐܂B
	* āAvfpbP[WgetĒǉ܂B
	* ipbP[WȂ΍ċAIɂ̃\bhĂaddĂ܂Bj
	* ŌɐvfԂ܂B
	*/
	private BoxClassTreeElement addTreeElm(String fullPath, boolean isPackage) {

		BoxClassTreeElement existingElm =
			(BoxClassTreeElement) elementsMap.get(fullPath);

		//łɂꍇAԂ܂B
		if (existingElm != null) {
			return existingElm;
		}

		//ꍇAelmNameŐ܂B
		BoxClassTreeElement addElm = null;
		String elmName = this.trimElmName(fullPath);

		if (isPackage) {
			addElm = new BoxPackage(elmName);
		}
		else {
			addElm = new BoxClass(elmName);
		}

		//addpbP[W擾Aǉ܂B
		String belongPackageName = this.trimBelongPackage(fullPath);
		BoxPackage belongPackage = (BoxPackage) elementsMap.get(belongPackageName);

		if (belongPackage == null) {
			//AaddpbP[WȂ΁AVɃpbP[W𐶐Ēǉ܂B
			//iVȃpbP[Wadd͍ċAIɌĂ΂܂Bj
			belongPackage = (BoxPackage) addTreeElm(belongPackageName, true);
		}

		belongPackage.add(addElm);

		//}bvɒǉ܂B
		elementsMap.put(fullPath, addElm);

		//AvOCNXł΁ApluginClassNameListɉ܂B
		if (pluginElements.contains(fullPath)) {
			this.pluginClassNames.add(addElm.getAbsoluteName());
			logger.debug(
				"BoxClassTreeCreator#pluginElmListadd܂Bname="
					+ addElm.getAbsoluteName());
		}

		return addElm;
	}

	/**
	* fullPath珊pbP[Wnameget܂B
	*  "./ibm/com/class"  "./ibm/com"
	*  eXĝ߁ApublicɂĂ܂B
	*/
	private String trimBelongPackage(String fullPath) {
		return fullPath.substring(0, fullPath.lastIndexOf("/"));
	}

	/**
	* fullPathelmNameget܂B
	*  "./ibm/com/hoge"  "hoge"
	*/
	//eXĝ߁ApublicɂĂ܂B
	private String trimElmName(String fullPath) {
		return fullPath.substring(fullPath.lastIndexOf("/") + 1);
	}
}