/*
 * BoxClassTreeElement.java
 *
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.container.classtree;

import javax.swing.tree.TreeNode;

import org.apache.log4j.Logger;

/**
 * BESPNXc[̗vfłB (Comnpositep^[łB)
 * m̃TuNX
 * EBoxClass
 * EBoxPackage
 * łB
 *
 * presentationContainerŕ\̍ہASwingJTreeboxClassTree\̂ŁA
 * java.swing.tree.TreeNodeC^[tF[Xp܂B
 * 
 * @author rx78g
 * @version $Id: BoxClassTreeElement.java,v 1.1 2004/03/21 12:07:49 macchan Exp $
*/
public abstract class BoxClassTreeElement implements TreeNode {

	private static final Logger logger =
		Logger.getLogger(BoxClassTreeElement.class.getName());

	/**
	* pbP[WԂdelimiterłBdefaultƂāu.vݒ肵܂B
	*/
	private static final String packageDelimiter = ".";

	/**
	* ̗vf̖O
	*/
	private String name;

	/**
	* ̗vf̐evf
	*/
	private BoxClassTreeElement parent;

	/**
	* RXgN^łB
	*/
	public BoxClassTreeElement(String newname) {
		name = newname;
	}

	/**
	* nameԂ܂B
	* @return ̗vfname
	*/
	public String getName() {
		return name;
	}

	/**
	* c[EH[NsȂ߁Ajavax.swing.tree.treeNodeC^[tF[X܂B
	* @return ̗vfparent
	*/
	public TreeNode getParent() {
		return parent;
	}

	/**
	* parentݒ肵܂B
	* @param elm ݒ肷parent
	*/
	public void setParent(BoxClassTreeElement elm) {
		this.parent = elm;
	}

	/**
	* c[̃pX܂nameԂ܂B
	* @return@pX܂name
	*/
	public String getAbsoluteName() {
		if (parent == null) {
			return "";
		}
		String parentPackageName = parent.getAbsoluteName();
		if (parentPackageName.equals("")) {
			return name;
		}
		return parentPackageName + packageDelimiter + name;
	}

	/**
	* visitor󂯕tC^[tF[XłB
	* @param visitor K₷visitor
	*/
	public abstract void visit(BoxClassTreeVisitor visitor);

	/**
	* vfnameԂ߂ɃI[o[Ch܂B
	* @return vfname
	*/
	public String toString() {
		return name;
	}
}