/*
 * BoxPackage.java
 *
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.container.classtree;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

import javax.swing.tree.TreeNode;

import org.apache.log4j.Logger;

/**
 * BoxClassTreeElementpāANXc[̃pbP[W`܂B
 * 0畡BoxClassTreeElement܂B(Comnpositep^[łB)
 * 
 * @author rx78g
 * @version $Id: BoxPackage.java,v 1.1 2004/03/21 12:07:49 macchan Exp $
 */
public class BoxPackage extends BoxClassTreeElement {

	private static final Logger logger =
		Logger.getLogger(BoxPackage.class.getName());

	/**
	* pbP[WɊ܂܂NXc[vfłB
	*/
	private Vector children = new Vector();

	/**
	 * @see org.boxed_economy.besp.container.classtree.BoxClassTreeElement#BoxClassTreeElement(String)
	 */
	public BoxPackage(String name) {
		super(name);
	}

	/**
	 * ̃pbP[WBoxClassTreeElementǉ܂B
	 * 
	 * @param element, ǉNXc[vf
	 */
	public void add(BoxClassTreeElement element) {
		element.setParent(this);
		this.children.addElement(element);
	}

	/**
	 * ̃pbP[WBoxClassTreeElement폜܂B
	 * 
	 * @param element, 폜NXc[vf
	 */
	public void remove(BoxClassTreeElement element) {
		element.setParent(null);
		this.children.removeElement(element);
	}

	/**
	 * qvfԂ܂
	 * 
	 * @return List
	 */
	public List getChildren() {
		return new ArrayList(this.children);
	}

	/*****************
	 * TreeNode̎
	 *****************/

	/**
	 * @see org.boxed_economy.besp.container.classtree.BoxClassTreeElement#visit(BoxClassTreeVisitor)
	 */
	public void visit(BoxClassTreeVisitor visitor) {
		visitor.visitPackage(this);
	}

	/**
	 * @see javax.swing.tree.TreeNode#getChildAt(int)
	 */
	public TreeNode getChildAt(int childIndex) {
		return (TreeNode) children.elementAt(childIndex);
	}

	/**
	 * @see javax.swing.tree.TreeNode#getChildCount()
	 */
	public int getChildCount() {
		return children.size();
	}

	/**
	 * @see javax.swing.tree.TreeNode#getIndex(TreeNode)
	 */
	public int getIndex(TreeNode node) {
		return children.indexOf(node);
	}

	/**
	 * @see javax.swing.tree.TreeNode#getAllowsChildren()
	 */
	public boolean getAllowsChildren() {
		return true;
	}

	/**
	 * @see javax.swing.tree.TreeNode#isLeaf()
	 */
	public boolean isLeaf() {
		return false;
	}

	/**
	 * @see javax.swing.tree.TreeNode#children()
	 */
	public Enumeration children() {
		return children.elements();
	}

}