/*
 * BoxRootPackage.java
 *
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.container.classtree;

import java.util.Arrays;
import java.util.List;

/**
 * NXc[ɂ郋[gpbP[W`܂B
 * ̃[gpbP[WTuc[𐶐邽߂̃\bh܂B
 * 
 * @author rx78g
 * @version $Id: BoxRootPackage.java,v 1.1 2004/03/21 12:07:49 macchan Exp $
 */
public class BoxRootPackage extends BoxPackage {

	/**
	 * @see org.boxed_economy.besp.container.classtree.BoxClassTreeElement#BoxClassTreeElement(String)
	 */
	public BoxRootPackage(String newname) {
		super(newname);
	}

	/**
	 * ̃NX̃TuNX擾ATuc[𐶐܂B
	 * 
	 * @param targetClass oNX
	 * @return Tuc[̃[gvf
	 */
	public BoxClassTreeElement createSubTree(Class targetClass) {
		FilteringClassBoxClassTreeVisitor visitor =
			new FilteringClassBoxClassTreeVisitor(targetClass);
		visitor.treewalk(this);
		Class[] classArray = visitor.getFilteredClasses();
		return new BoxClassTreeCreator().createFromClassArray(classArray);
	}
	
	/**
	 * ̃NX̃TuNXpANX𒊏oĂ̑SXg擾܂
	 * 
	 * @param targetClass oNX
	 * @return YNX̃Xg
	 */
	public List getFilteredClasses(Class targetClass) {
		FilteringClassBoxClassTreeVisitor visitor =
			new FilteringClassBoxClassTreeVisitor(targetClass);
		visitor.treewalk(this);
		return Arrays.asList(visitor.getFilteredClasses());
	}	

}
