/*
 * CleaningInvalidClassBoxClassTreeVisitor.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.container.classtree;

import org.apache.log4j.Logger;

/**
 * NXc[svȃNX菜߂VisitorłB
 * NX̖O画fBESPNXc[菜܂B
 * 
 * @author macchan
 * @version $Id: CleaningInvalidClassBoxClassTreeVisitor.java,v 1.1 2004/03/21 12:07:49 macchan Exp $
 */
public class CleaningInvalidClassBoxClassTreeVisitor
	extends BoxClassTreeVisitor {

	private static final Logger logger =
		Logger.getLogger(CleaningInvalidClassBoxClassTreeVisitor.class.getName());

	/**
	* NXc[őΏۂƂȂNXinfix
	*/
	private static final String[] outOfTargetClass =
		{
			"sun",
			"java",
			"demos",
			"javax",
			"junit",
			"netscape",
			"sunw",
			"com.sun",
			"org.omg",
			"tcl" };

	/**
	 * @see org.boxed_economy.besp.container.classtree.BoxClassTreeVisitor#visitPackage(BoxPackage)
	 * ܂
	 */
	public void visitPackage(BoxPackage target) {
	}

	/**
	 * @see org.boxed_economy.besp.container.classtree.BoxClassTreeVisitor#visitClass(BoxClass)
	 */
	public void visitClass(BoxClass target) {
		String className = target.getAbsoluteName();

		//ȓΏۂ1 rΏۃNX̏ꍇ
		if (isOutOfTargetClass(className)) {
			logger.debug("out of target class = " + className);
			this.cleanClass(target);
		}

		//ȓΏۂ2 Class.forName()ŃG[oꍇ
		try {
			//Class.forName(className, false, ClassLoader.getSystemClassLoader());
			Class.forName(className, true, ClassLoader.getSystemClassLoader());
		}
		catch (Throwable th) {
			logger.debug("Class.forName() error class= " + className);
			this.cleanClass(target);
		}
	}

	/**
	 * r܂
	 */
	private void cleanClass(BoxClass target) {
		BoxClassTreeElement parent = (BoxClassTreeElement) target.getParent();
		if (parent != null && parent instanceof BoxPackage) {
			((BoxPackage) parent).remove(target);
		}
	}

	/**
	 * rΏۃNXǂׂ܂
	 */
	private boolean isOutOfTargetClass(String className) {
		for (int i = 0; i < outOfTargetClass.length; i++) {
			if (className.startsWith(outOfTargetClass[i])) {
				return true;
			}
		}
		return false;
	}

}
