/*
 * FilteringClassBoxClassTreeVisitor.java
 *
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.container.classtree;

import java.util.List;
import java.util.Vector;

import org.apache.log4j.Logger;

/**
 * NXc[̒ÃNX𒊏oVisitorłB
 * ̃NXyсApCX^X𒊏o܂B@
 * 
 * @author rx78g
 * @version $Id: FilteringClassBoxClassTreeVisitor.java,v 1.1 2004/03/21 12:07:49 macchan Exp $
 */
public class FilteringClassBoxClassTreeVisitor extends BoxClassTreeVisitor {

	private static final Logger logger =
		Logger.getLogger(FilteringClassBoxClassTreeVisitor.class.getName());

	/**
	* oꂽNXQł
	*/
	private List filteredClassses = new Vector();

	/**
	* oeNXł
	*/
	private Class filteringTargetClass = null;

	/**
	* RXgN^łB
	*/
	public FilteringClassBoxClassTreeVisitor(Class filteringTargetClass) {
		this.filteringTargetClass = filteringTargetClass;
	}

	/**
	* oNXIuWFNg̔zԂ܂B
	* @return oNX̔z
	*/
	public Class[] getFilteredClasses() {
		//̂̂𔲂
		this.filteredClassses.remove(this.filteringTargetClass);

		//z쐬ĕԂ
		Class[] filteredArray = new Class[this.filteredClassses.size()];
		return (Class[]) filteredClassses.toArray(filteredArray);
	}

	/**
	 * BoxPackageK₵ƂɃR[obN郁\bhłB
	 * NX𒊏o邽߁A܂B
	 * 
	 * @see org.boxed_economy.besp.container.classtree.BoxClassTreeVisitor#visitPackage(BoxPackage)
	 */
	public void visitPackage(BoxPackage targetPackage) {
		//܂
	}

	/**
	 * pbP[W̖K₵ƂɃR[obN郁\bhłB
	 * filteringTargetClassA邢͌pNXłΒofilteredClasssesɒǉ܂B
	 * 
	 * @see org.boxed_economy.besp.container.classtree.BoxClassTreeVisitor#visitClass(BoxClass)
	 */
	public void visitClass(BoxClass targetClass) {
		try {
			String className = targetClass.getAbsoluteName();

			//Class loadedClass = Class.forName(className, false, ClassLoader.getSystemClassLoader());
			Class loadedClass =
				Class.forName(className, true, ClassLoader.getSystemClassLoader());

			//otarget̃NX̃TuNXi̓C^[tF[X́jł΁A
			//XgɉB
			if (this.filteringTargetClass.isAssignableFrom(loadedClass)) {
				filteredClassses.add(loadedClass);
			}
		}
		catch (Throwable th) {
			logger.warn(
				"throwable in load class = " + targetClass.getAbsoluteName(),
				th);
		}
	}

}
