/*
 * ModelContainer.java
 *
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.model;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.container.BESP;
import org.boxed_economy.besp.container.BESPContainer;
import org.boxed_economy.besp.model.fmfw.AgentType;
import org.boxed_economy.besp.model.fmfw.Behavior;
import org.boxed_economy.besp.model.fmfw.BehaviorType;
import org.boxed_economy.besp.model.fmfw.FMFWConstants;
import org.boxed_economy.besp.model.fmfw.GoodsType;
import org.boxed_economy.besp.model.fmfw.Information;
import org.boxed_economy.besp.model.fmfw.InformationType;
import org.boxed_economy.besp.model.fmfw.RelationType;
import org.boxed_economy.besp.model.fmfw.TypeManager;
import org.boxed_economy.besp.model.fmfw.World;
import org.boxed_economy.besp.presentation.PresentationContainer;

/**
* fRei[łB
* fݒEXV郁\bh܂B܂AfXbhێ܂B
* 
* @author rx78g
* @version $Id: ModelContainer.java,v 1.1 2004/03/21 12:07:49 macchan Exp $
*/
public class ModelContainer {

	private static final Logger logger =
		Logger.getLogger(ModelContainer.class.getName());

	/*******
	 * 萔
	 *******/
	public static final int PRIORITY_DEFAULT = 0;

	/**
	 * ReiłB
	 */
	private BESPContainer container = null;

	/**
	* ݊JĂ郂fłB
	*/
	private World model = null;

	/**
	* ǂݍ܂Ăi邢͕ۑĂjFilełB
	*/
	private File file = null;

	/**
	* f𓮂XbhłB
	*/
	private ModelThread modelThread = new ModelThread(this);

	/**
	 * błBfŎgTypẽXgVoicabularyNXłB
	 */
	private TypeManager vocabulary = new TypeManager();

	/**
	* vCIeB[ǗIuWFNgł
	*/
	private PriorityManager priorityManager = new PriorityManager();

	/**
	 * Constructor for ModelContainer.
	 */
	public ModelContainer(BESPContainer container) {
		this.container = container;
	}

	/***************
	 * 
	 ***************/

	/**
	* sȂ܂B
	*/
	public void initialize() {
		FMFWConstants.initialize(this);
		this.installInformationTypes();
		this.installBehaviorTypes();
	}

	/**
	 * NXpX̑SĂInformationNX𒊏o
	 * InformaitionTypeCXg[܂
	 */
	private void installInformationTypes() {
		List classes = BESP.classTreeRoot.getFilteredClasses(Information.class);
		Iterator i = classes.iterator();
		while (i.hasNext()) {
			Class clazz = (Class) i.next();
			this.installInformationType(clazz.getName());
		}
	}

	/**
	 * NXpX̑SĂBehaviorNX𒊏o
	 * BehaviorTypeCXg[܂
	 */
	private void installBehaviorTypes() {
		List classes = BESP.classTreeRoot.getFilteredClasses(Behavior.class);
		Iterator i = classes.iterator();
		while (i.hasNext()) {
			Class clazz = (Class) i.next();
			this.installBehaviorType(clazz.getName());
		}
	}

	/**
	 * IsȂ܂B
	 */
	public void terminate() {
	}

	/***************
	 * container֘A
	 ***************/

	public BESPContainer getContainer() {
		return this.container;
	}

	public PresentationContainer getPresentationContainer() {
		return this.getContainer().getPresentationContainer();
	}

	/***************
	 * E֘A
	 ***************/

	public World getModel() {
		return this.model;
	}

	public void setModel(final World model) {
		assert getModelThread().getState() == ModelThread.STOPPED;

		Thread setModelThread = new Thread() {
			public void run() {
				if (ModelContainer.this.model != null) {
					finalizeWorld(ModelContainer.this.model);
				}
				initializeWorld(model);
			}
		};
		setModelThread.start();
	}

	private void finalizeWorld(World model) {
		this.firePrepareWorldClose(new ModelContainerEvent(this, model));
		this.model = null;
		this.fireWorldClosed(new ModelContainerEvent(this, model));
	}

	private void initializeWorld(World model) {
		assert model != null;

		this.model = model;
		this.model.setModelContainer(this);
		this.firePrepareWorldOpen(new ModelContainerEvent(this, this.model));
		this.model.initialize();
		this.fireWorldOpened(new ModelContainerEvent(this, this.model));
	}

	/***************
	 * File֘A
	 ***************/

	public File getFile() {
		return this.file;
	}

	/**
	* model̏o͂AboxFilew肵čsȂ܂B
	* ƂĎw肵boxFileɏo͂܂B
	* ȍ~͈boxFileboxFileƂĎw肳܂B
	* @param newboxFile o͂boxFile
	*/
	public void setFile(File file) {
		this.file = file;
	}

	/*********************
	 * thread֘A
	 *********************/

	public ModelThread getModelThread() {
		return this.modelThread;
	}

	/**
	 * threadɌݐݒ肳ĂsݒԂ܂B
	 * @return LimitedTimeRunSetting
	 */
	public LimitedTimeRunSetting getLimitedTimeRunSetting() {
		return this.modelThread.getLimitedRunSetting();
	}

	/**
	 * ClockɎsݒݒ肵܂B
	 * @param setteing The setteing to set
	 */
	public void setLimitedRunSetting(LimitedTimeRunSetting setting) {
		this.modelThread.setLimitedRunSetting(setting);
	}

	/*********************
	 * vocabulary֘A
	 *********************/

	/**
	* L[ɊYAgentType擾܂B
	* ݂Ȃ΁AnullԂ܂B
	* @param key L[
	*/
	public AgentType getAgentType(String key) {
		return this.vocabulary.getAgentType(key);
	}

	/**
	* L[ɊYBehaviorType擾܂B
	* ݂Ȃ΁AnullԂ܂B
	* @param key L[
	*/
	public BehaviorType getBehaviorType(String key) {
		return this.vocabulary.getBehaviorType(key);
	}

	/**
	* L[ɊYGoodsType擾܂B
	* ݂Ȃ΁AnullԂ܂B
	* @param key L[
	*/
	public GoodsType getGoodsType(String key) {
		return this.vocabulary.getGoodsType(key);
	}

	/**
	* L[ɊYInformationType擾܂B
	* ݂Ȃ΁AnullԂ܂B
	* @param key L[
	*/
	public InformationType getInformationType(String key) {
		return this.vocabulary.getInformationType(key);
	}

	/**
	* L[ɊYRelationType擾܂B
	* ݂Ȃ΁AnullԂ܂B
	* @param key L[
	*/
	public RelationType getRelationType(String key) {
		return this.vocabulary.getRelationType(key);
	}

	/**
	 * SĂAgentTypeԂ܂B
	 */
	public Collection getAgentTypes() {
		return this.vocabulary.getAgentTypes();
	}

	/**
	* SĂBehaviorTypeԂ܂B
	*/
	public Collection getBehaviorTypes() {
		return this.vocabulary.getBehaviorTypes();
	}

	/**
	* SĂGoodsTypeԂ܂B
	*/
	public Collection getGoodsTypes() {
		return this.vocabulary.getGoodsTypes();
	}

	/**
	* SĂInformationTypeԂ܂B
	*/
	public Collection getInformationTypes() {
		return this.vocabulary.getInformationTypes();
	}

	/**
	* SĂRelationTypeԂ܂B
	*/
	public Collection getRelationTypes() {
		return this.vocabulary.getRelationTypes();
	}

	/**
	 * AgentType𐶐ĕԂ܂BType͕̐K̃\bhpčsĉB
	 * @param name Type̖O
	 * @return AgentType ꂽType
	 */
	public AgentType installAgentType(String name) {
		return this.installAgentType(name, PRIORITY_DEFAULT);
	}

	/**
	 * AgentType𐶐ĕԂ܂BType͕̐K̃\bhpčsĉB
	 * @param name Type̖O
	 * @return AgentType ꂽType
	 */
	public AgentType installAgentType(String name, int priority) {
		AgentType type = this.vocabulary.installAgentType(name);
		this.setPriority(type, priority);
		return type;
	}

	/**
	* GoodsType𐶐ĕԂ܂BType͕̐K̃\bhpčsĉB
	* @param name Type̖O
	* @return GoodsType ꂽType
	*/
	public GoodsType installGoodsType(String name) {
		return this.vocabulary.installGoodsType(name);
	}

	/**
	* BehaviorType𐶐ĕԂ܂BType͕̐K̃\bhpčsĉB
	* @param name Type̖O
	* @return BehaviorType ꂽType
	*/
	public BehaviorType installBehaviorType(String name) {
		return this.vocabulary.installBehaviorType(name);
	}

	/**
	* RelationType𐶐ĕԂ܂BType͕̐K̃\bhpčsĉB
	* @param name Type̖O
	* @return RelationType ꂽType
	*/
	public RelationType installRelationType(String name) {
		return this.vocabulary.installRelationType(name);
	}

	/**
	* InformationType𐶐ĕԂ܂BType͕̐K̃\bhpčsĉB
	* @param name Type̖O
	* @return InformationType ꂽType
	*/
	public InformationType installInformationType(String name) {
		return this.vocabulary.installInformationType(name);
	}

	/*********************
	 * priority֘A
	 *********************/

	/**
	 * AgentTypeɑΉPriorityԂ܂B
	 * A݂ȂnullԂ܂B
	 * @param agentType 擾PriorityType
	 * @return Priority YPriority
	 */
	public int getPriority(AgentType agentType) {
		return this.priorityManager.getPriority(agentType);
	}

	/**
	 * Priorityǉݒ肵܂B
	 * @param priorityValue ǉPriority
	 * @param agentType ֘AtType
	 */
	public void setPriority(AgentType agentType, int priority) {
		this.priorityManager.setPriority(agentType, priority);
	}

	/**
	 * ~ɐ񂳂ꂽvCIeB[̃XgԂ܂
	 */
	public List getOrderdPriorities() {
		return this.priorityManager.getOrderdPriorities();
	}

	/*********************
	 * CxgzM֘A
	 *********************/
	private Vector modelContainerListeners;

	public synchronized void addModelContainerListener(ModelContainerListener l) {
		Vector v =
			modelContainerListeners == null
				? new Vector(2)
				: (Vector) modelContainerListeners.clone();
		if (!v.contains(l)) {
			v.addElement(l);
			modelContainerListeners = v;
		}
	}

	public synchronized void removeModelContainerListener(ModelContainerListener l) {
		if (modelContainerListeners != null
			&& modelContainerListeners.contains(l)) {
			Vector v = (Vector) modelContainerListeners.clone();
			v.removeElement(l);
			modelContainerListeners = v;
		}
	}

	protected void firePrepareWorldOpen(ModelContainerEvent e) {
		if (modelContainerListeners != null) {
			Vector listeners = modelContainerListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				(
					(ModelContainerListener) listeners.elementAt(
						i)).prepareWorldOpen(
					e);
			}
		}
	}

	protected void fireWorldOpened(ModelContainerEvent e) {
		if (modelContainerListeners != null) {
			Vector listeners = modelContainerListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				((ModelContainerListener) listeners.elementAt(i)).worldOpened(
					e);
			}
		}
	}

	protected void firePrepareWorldClose(ModelContainerEvent e) {
		if (modelContainerListeners != null) {
			Vector listeners = modelContainerListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				(
					(ModelContainerListener) listeners.elementAt(
						i)).prepareWorldClose(
					e);
			}
		}
	}

	protected void fireWorldClosed(ModelContainerEvent e) {
		if (modelContainerListeners != null) {
			Vector listeners = modelContainerListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				((ModelContainerListener) listeners.elementAt(i)).worldClosed(
					e);
			}
		}
	}

}
