/*
 * ModelThread.java
 *
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Vector;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.fmfw.Agent;
import org.boxed_economy.besp.model.fmfw.AgentType;
import org.boxed_economy.besp.model.fmfw.Clock;
import org.boxed_economy.besp.model.fmfw.DefaultRandomNumberGenerator;
import org.boxed_economy.besp.model.fmfw.FMFWConstants;
import org.boxed_economy.besp.model.fmfw.RandomNumberGenerator;
import org.boxed_economy.besp.model.fmfw.TimeEvent;
import org.boxed_economy.besp.model.fmfw.World;

/**
 * WorldɔzuꂽClockAAgentɑ΂TimeEvent𔭐M邱ƂŃf쓮NXłB
 * 
 * @author rx78g
 * @version $Id: ModelThread.java,v 1.3 2004/05/06 17:48:24 macchan Exp $
 */
public class ModelThread implements Runnable {

	private static final Logger logger =
		Logger.getLogger(ModelThread.class.getName());

	//Ԓ萔
	public static final int STOPPED = 1;
	public static final int STOPPING = 2;
	public static final int RUNNING = 3;

	//Xbh̒萔
	private static final String THREAD_NAME = "modelThread";
	private static final int THREAD_PRIORITY_DEFAULT = 4;
	private static final int EVENT_DISPATCH_INTERVAL_DEFALUT = 100;

	/**
	 * thread̏containerłB
	 */
	private ModelContainer modelContainer = null;

	/**
	 * Xbh̏
	 */
	private volatile int state = STOPPED;

	/**
	 * V~[^TimeEventzMԊu~bŕ\킵̂łB	
	 */
	private long eventDispatchInterval = EVENT_DISPATCH_INTERVAL_DEFALUT;

	/**
	 * V~[V̎s񐔂łB
	 */
	private long runStepNum = 0;

	/**
	 * ݐis̃Xbh
	 */
	private Thread thread = null;

	/**
	 * Ήsݒ
	 */
	private LimitedTimeRunSetting setting = null;

	/*************
	 * RXgN^
	 *************/

	/**
	 * RXgN^łB
	 * @param newmodelContainer ݒ肷modelContainer
	 */
	public ModelThread(ModelContainer modelContainer) {
		this.modelContainer = modelContainer;
	}

	/**********
	 * Ԋ֘A
	 **********/

	/**
	 * ݂̏Ԃ擾܂
	 * @return threadstate
	 */
	public int getState() {
		return this.state;
	}

	/**
	 * ݂̏Ԃݒ肵܂iԂJڂ܂j
	 * @param state Vݒ肷
	 */
	private void setState(int state) {
		if (this.state != state) {
			logger.debug("transition " + this.state + "=>" + state);
			this.state = state;
			this.fireSimulationStateEvent();
		}
	}

	/**
	 * ԕύXCxgzM܂
	 */
	private void fireSimulationStateEvent() {
		SimulationStateEvent ev = new SimulationStateEvent(this);
		switch (this.state) {
			case RUNNING :
				this.firePresentationComponentStarted(ev);
				break;
			case STOPPING :
				this.firePresentationComponentStopping(ev);
				break;
			case STOPPED :
				this.firePresentationComponentStopped(ev);
				break;
			default :
				throw new ModelException("illegal state set at model executer");
		}
	}

	/*****************
	 * XbhJnA~
	 *****************/

	/**
	 * ThreadX^[gAV~[Vi߂܂
	 * stop\bhĂ΂܂ŁAV~[V𓮂Â܂B
	 * Ahourł͂ȂAlong^̍ővaluẻ񐔂œ܂B
	 */
	public synchronized void start() throws Exception {
		this.start(Long.MAX_VALUE); // long̍ővalueminutePȂ񐔂JԂ
	}

	/**
	 * Ŏw肵񐔂V~[VssȂ܂B
	 * @param step s
	 */
	public synchronized void start(long step) throws Exception {
		logger.debug("start() step=" + step);

		// }CiXstepNumł́ArunłȂB
		if (step < 0) {
			logger.warn(
				"cannot start because step is too small (step = "
					+ step
					+ ") ");
			return;
		}

		// runStepNum̐ݒ
		this.runStepNum = step;

		// threadKvɉcreateAstart
		if (thread == null) {
			this.setState(RUNNING);
			thread = new Thread(this, THREAD_NAME);
			thread.setPriority(THREAD_PRIORITY_DEFAULT);
			thread.start();
			wait(); //Sstart܂ő҂BrunN
		} else {
			logger.warn("modelThread#threadstart SstopĂȂ̂startł܂B");
			return;
		}

		logger.debug(
			"modelThread#threadstart() start܂,VXehour="
				+ System.currentTimeMillis());

	}

	/**
	 * V~[ViCxg̔zMj~܂B
	 */
	public synchronized void stop() {
		logger.debug("thread stop()  called");
		if (this.getState() == RUNNING) {
			this.setState(STOPPING);
			this.notifyAll(); //ThreadQĂNB
		}
	}

	/*****************
	 * sWbN
	 *****************/

	/**
	 * run()
	 * Runnable interface̎łB
	 */
	public void run() {
		logger.debug("run() start");

		try {
			long runNum = 0; // clockEvent𔭐M
			synchronized (this) {
				this.setState(RUNNING);
				this.notifyAll(); //SstartƂ#startɓ`܂B
			}

			// RUNNING̊Event𔭐Mwhile[vłB
			while (this.state == RUNNING && runNum < runStepNum) {

				// Event𔭐M܂ő҂܂B
				logger.debug("before wait " + eventDispatchInterval);
				synchronized (this) {
					wait(eventDispatchInterval);
				}
				logger.debug("after wait");

				//TimeEventzM܂B
				this.deliverTimeEvent();
				runNum++; // JE^[𑝂₷
			}

		} catch (Exception ex) {
			this.modelContainer.getPresentationContainer().showError(
				"Exception in ModelThread EventLoop",
				ex);

		} finally {
			this.thread = null; // start()ɔ邽߂threadnull
			this.setState(STOPPED); //threadstopstateɂ
		}

		logger.debug("run() end");
	}

	/******************
	 * 莞Ԏs֘A
	 ******************/
	/**
	 * ݐݒ肳ĂsݒԂ܂BftHg͂PXebvsł
	 * @return LimitedTimeRunSetting
	 */
	protected LimitedTimeRunSetting getLimitedRunSetting() {
		return this.setting;
	}

	/**
	 * sݒݒ肵܂B
	 * @param setteing The setteing to set
	 */
	protected void setLimitedRunSetting(LimitedTimeRunSetting setting) {
		this.setting = setting;
	}

	/******************
	 * TimeCxg֘A
	 ******************/

	/**
	 * TimeEventzM郁\bhłB
	 */
	private void deliverTimeEvent() {
		if (modelContainer != null && modelContainer.getModel() != null) {
			this.deliverTimeEvent(modelContainer.getModel());
		}
	}

	/**
	 *@TimeEventClockAgentɑ΂ĔzM郁\bhłB
	 */
	public void deliverTimeEvent(World world) {
		//ClockPrepareEvent𔭐M
		Clock clock = world.getClock();
		if (clock != null) {
			clock.prepareStep();
		}

		//eG[WFgTimeEventPriorityƂɔM܂B
		List pList = this.modelContainer.getOrderdPriorities();
		Collections.sort(pList);
		Iterator i = pList.iterator();
		while (i.hasNext()) {
			Priority p = (Priority) i.next();
			Iterator j = this.shuffledAgentList(p).iterator();
			while (j.hasNext()) {
				Agent agent = (Agent) j.next();
				agent.receiveTimeEvent(new TimeEvent(this));
			}
		}

		//ClockGainEvent𔭐M
		if (clock != null) {
			clock.receiveTimeEvent(new TimeEvent(this));
		}
	}

	/**
	 * PriorityɑΉAgentTypeɊ֌WȂVbtŕԂ܂B
	 * 
	 * @param world type݂world
	 * @return List VbtꂽAgentList
	 */
	private synchronized List shuffledAgentList(Priority priority) {
		ArrayList targetAgents = new ArrayList();
		Iterator i = priority.getAgentTypes().iterator();
		while (i.hasNext()) {
			AgentType at = (AgentType) i.next();
			Collection agents = this.modelContainer.getModel().getAgents(at);
			targetAgents.addAll(agents);
		}
		ArrayList value = new ArrayList(targetAgents);
		RandomNumberGenerator gen =
			modelContainer.getModel().getRandomNumberGenerator(
				FMFWConstants.RANDOM_TIMEEVENT);
		Random random = ((DefaultRandomNumberGenerator) gen).getRandom();

		//System.out.println(value);
		//System.out.println(random.toString());
		//System.out.println(random.nextInt());	

		Collections.shuffle(value, random);
		//System.out.println(value);

		return value;
	}

	/***********************
	 * TimeEventzMԊu֘A
	 ***********************/

	/**
	* eventDispatchIntervalԂ܂B
	* @return threadeventDispatchInterval
	*/
	public long getEventDispatchInterval() {
		return this.eventDispatchInterval;
	}

	/**
	 * zMԊuύX܂B
	 * 
	 * KAstopstateōsȂKv܂B
	 * stopstatełȂꍇAύX܂BWarning𔭍s܂B
	 *
	 * 0ȉݒ肳ꂽꍇAŒvalue1ݒ肳܂B
	 * @param neweventDispatchInterval ݒ肷eventDispatchInterval
	 */
	public synchronized void setEventDispatchInterval(long interval) {
		assert this.getState() == STOPPED;

		// 0ȉw肳ꂽ
		if (interval < 1) {
			throw new IllegalArgumentException("Cannot Set EventDispathInterval below Zero");
		}

		this.eventDispatchInterval = interval;
		logger.info(
			"Set EventDispatchInterval = " + this.eventDispatchInterval);
	}

	/*********************
	 * ԃCxgzM֘A
	 *********************/
	protected Vector simulationStateListeners = null;

	public synchronized void addSimulationStateListener(SimulationStateListener l) {
		Vector v =
			simulationStateListeners == null
				? new Vector(2)
				: (Vector) simulationStateListeners.clone();
		if (!v.contains(l)) {
			v.addElement(l);
			simulationStateListeners = v;
		}
	}

	public synchronized void removeSimulationStateListener(SimulationStateListener l) {
		if (simulationStateListeners != null
			&& simulationStateListeners.contains(l)) {
			Vector v = (Vector) simulationStateListeners.clone();
			v.removeElement(l);
			simulationStateListeners = v;
		}
	}

	protected void firePresentationComponentStarted(SimulationStateEvent e) {
		if (simulationStateListeners != null) {
			Vector listeners = simulationStateListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				(
					(SimulationStateListener) listeners.elementAt(
						i)).simulationStarted(
					e);
			}
		}
	}

	protected void firePresentationComponentStopping(SimulationStateEvent e) {
		if (simulationStateListeners != null) {
			Vector listeners = simulationStateListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				(
					(SimulationStateListener) listeners.elementAt(
						i)).simulationStopping(
					e);
			}
		}
	}

	protected void firePresentationComponentStopped(SimulationStateEvent e) {
		if (simulationStateListeners != null) {
			Vector listeners = simulationStateListeners;
			int count = listeners.size();
			for (int i = 0; i < count; i++) {
				(
					(SimulationStateListener) listeners.elementAt(
						i)).simulationStopped(
					e);
			}
		}
	}

}
