/*
 * Priority.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.model;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

import org.boxed_economy.besp.model.fmfw.AgentType;

/**
 * G[WFgւTimeEventMԂ̃vCIeB[łB
 * 
 * @author macchan
 * @version $Id: Priority.java,v 1.1 2004/03/21 12:07:49 macchan Exp $
 */
public class Priority implements Comparable {

	private int value = ModelContainer.PRIORITY_DEFAULT;

	private Set agentTypes = new LinkedHashSet();

	/**
	 * RXgN^
	 * @param priority Priority̒l
	 */
	public Priority(int value) {
		this.value = value;
	}

	/****************
	 * value֘A
	 ****************/

	public int getValue() {
		return this.value;
	}

	/****************
	 * agentType֘A
	 ****************/

	public void addAgentType(AgentType agentType) {
		this.agentTypes.add(agentType);
	}

	public void removeAgentType(AgentType agentType) {
		this.agentTypes.remove(agentType);
	}

	public List getAgentTypes() {
		return new ArrayList(this.agentTypes);
	}

	/****************
	 * comparable
	 ****************/

	public int compareTo(Object o) {
		return ((Priority) o).value - value;
	}

}
