/*
 * PriorityManager.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.boxed_economy.besp.model.fmfw.AgentType;

/**
 * WorldϏāAPriorityǗNXłB
 * 
 * @author macchan
 * @version $Id: PriorityManager.java,v 1.1 2004/03/21 12:07:49 macchan Exp $
 */
public class PriorityManager {

	private Map prioritiesByInt = new HashMap(); //int=>Priority
	private Map prioritiesByAgentType = new HashMap(); //AgentType=>Priority

	/**
	 * AgentTypeɑΉPriorityԂ܂B
	 * A݂ȂnullԂ܂B
	 * 
	 * @param agentType 擾PriorityType
	 * @return Priority YPriority
	 */
	public int getPriority(AgentType agentType) {
		Priority priority = (Priority) this.prioritiesByAgentType.get(agentType);
		return priority.getValue();
	}

	/**
	 * Priorityǉݒ肵܂B
	 * 
	 * @param priorityValue ǉPriority
	 * @param agentType ֘AtType
	 */
	public void setPriority(AgentType agentType, int priorityValue) {
		//OPriority폜
		Priority oldPriority =
			(Priority) this.prioritiesByAgentType.remove(agentType);
		if (oldPriority != null) {
			oldPriority.removeAgentType(agentType);
			this.prioritiesByAgentType.put(agentType, null);
		}

		//Priorityɒǉ				
		Integer priorityInt = new Integer(priorityValue);
		Priority newPriority = getPriority(priorityInt);
		newPriority.addAgentType(agentType);
		this.prioritiesByAgentType.put(agentType, newPriority);
	}

	/**
	 * ŗ^ꂽD揇ʂPriorityIuWFNg擾
	 */
	private Priority getPriority(Integer priorityInt) {

		//̐Priority܂ݒ肳ĂȂꍇ
		if (!this.prioritiesByInt.containsKey(priorityInt)) {
			Priority priority = new Priority(priorityInt.intValue());
			this.prioritiesByInt.put(priorityInt, priority);
		}

		return (Priority) this.prioritiesByInt.get(priorityInt);
	}

	/**
	 * ~ɐ񂳂ꂽvCIeB[̃XgԂ܂
	 * @return vCIeB[Xg
	 */
	public List getOrderdPriorities() {
		List list = new ArrayList(this.prioritiesByInt.values());
		Collections.sort(list);
		return list;
	}

}
