/*
 * Agent.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw;

import java.util.Collection;
import java.util.List;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.update.UpdateAgentEvent;

/**
 * BoxedEconomyɂG[WFgƂȂNXłBworldɔzu܂B
 * --ȉ̃IuWFNgLAManagerNXʂĊǗ܂B
 * Goods,Behavior,Relation,Information
 * 
 * ܂ATimeEvent󂯎Behavior쓮܂B
 * Agent͌p邱ƂOɂ͂Ă܂B
 * 
 * @author macchan
 * @version $Id: Agent.java,v 1.2 2004/03/21 20:07:07 macchan Exp $
 */
public final class Agent extends Entity {

	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(Agent.class.getName());

	private AgentType type = null;
	private GoodsManager goodsManager = null;
	private RelationManager relationManager = null;
	private BehaviorManager behaviorManager = null;

	/**
	 * Agent𐶐RXgN^łB
	 * @param type Ɏw肷AgentType
	 */
	protected Agent(AgentType type) {
		this.type = type;
	}

	/**
	* agent̎goodsManagerAinformationManagerArelationManagerAbehaviorManager
	* initalize܂BworldĂ΂܂B
	*/
	public void initialize() {
		goodsManager = new GoodsManager();
		relationManager = new RelationManager(this);
		behaviorManager = new BehaviorManager(this);
	}

	/**
	 * AgentType擾܂D
	 * @return type AgentType
	 */
	public AgentType getType() {
		return this.type;
	}

	/**
	 * AgentSi邢͓|Yj鎞ɌĂ΂郁\bhłB
	 */
	public void destroy() {
		behaviorManager.removeAllBehaviors();
		this.getWorld().destroyAgent(this);
		//this.setWorld(null);
	}

	/**
	 * TimeEvent󂯎behaviorManagerɑ܂B
	 * @param e TimeEvent
	 */
	public void receiveTimeEvent(TimeEvent e) {
		behaviorManager.receiveTimeEvent(e);
	}

	/**
	* AgentSi邢͓|YjƂɁAAgentƂ̊֌W폜邽߂
	* Ă΂郁\bhłBAgentManagerĂ΂܂B
	* @param target Si邢͓|YAŁjAgent
	*/
	public void receiveDeathEvent(Agent target) {
		relationManager.removeRelationsByAgent(target);
	}

	/***********
	 * Information֌W
	 ***********/

	/**
	 * Informationǉ܂BKeyInformationw肵ĂB
	 * @param key L[Information
	 * @param value lInformation
	 */
	public void putInformation(Information key, Information value) {
		super.putInformation(key, value);
		this.fireInformationAdded(new UpdateAgentEvent(this, value));
	}

	/**
	 * InformationL[ƂInformation(cloneł͂܂)Ԃ܂
	 * L[ȂꍇAExceptionԂ܂B
	 * @param key
	 * @return Information
	 */
	public Information getInformation(Information key) {
		return super.getInformation(key);
	}

	/**
	 * InformationL[ƂInformation폜܂B
	 * L[ȂꍇAExceptionԂ܂B
	 * @param key L[
	 * @return Information 폜Information
	 */
	public Information removeInformation(Information key) {
		Information value = super.removeInformation(key);
		this.fireInformationRemoved(new UpdateAgentEvent(this, value));
		return value;
	}

	/*****************
	* Behavior֌W
	*****************/

	/**
	 * Behaviorǉ܂BǉꂽBehavior͊JnԂƂ܂B
	 * ̎AǉꂽBehaviorɂAgentZbg܂B
	 * @param newBehavior VǉBehaviorType
	 */
	public void addBehavior(BehaviorType type) {
		try {
			Class behaviorClass = Class.forName(type.getName());
			Behavior newBehavior = (Behavior) (behaviorClass.newInstance());
			newBehavior.setType(type);
			behaviorManager.addBehavior(newBehavior);
			this.fireBehaviorAdded(new UpdateAgentEvent(this, newBehavior));
			newBehavior.run();
		} catch (Exception ex) {
			throw new ModelException("caught exception in addBehavior", ex);
		}
	}

	/**
	 * BehaviorIč폜܂B
	 * ̃\bhɌABehaviorĨgu邽protectedɂ܂B
	 * @param target 폜Behavior
	 */
	public void removeBehavior(Behavior behavior) {
		behaviorManager.removeBehavior(behavior);
		this.fireBehaviorRemoved(new UpdateAgentEvent(this, behavior));
	}

	/**
	 * TypełBehaviorԂ܂B(݂ĂꍇAԏ߂ɒǉꂽBehaviorԂ܂)
	 * A݂ȂException܂B
	 * @param type ΏۂType
	 * @return Collection YBehavior̃Xg
	 */
	public Behavior getBehavior(BehaviorType type) {
		return behaviorManager.getBehavior(type);
	}

	/**
	 * TypełBehaviorCollectionƂđSĕԂ܂B
	 * A݂Ȃ΋CollectionԂ܂B
	 * @param type ΏۂType
	 * @return List YRelatioñXg
	 */
	public Collection getBehaviors(BehaviorType type) {
		return behaviorManager.getBehaviors(type);
	}

	/**
	 * Typeyт̎q^CvłBehaviorCollectionƂđSĕԂ܂B
	 * A݂Ȃ΋CollectionԂ܂B
	 * @param type ΏۂType
	 * @return List YBehavior̃Xg
	 */
	public Collection getBehaviorsRecursively(BehaviorType type) {
		return behaviorManager.getBehaviorsRecursively(type);
	}

	/**
	 * Returns All Behaviors.
	 * @return Collection The collection which has all behaviors.
	 */
	public List getAllBehaviors() {
		return behaviorManager.getAllBehaviors();
	}

	/**
	 * ChannelJ݂邽߂ChannelOpenEvent󂯎郁\bhłB
	 * ChannelEvent󂯎BehaviorŏIIɕԂ܂B
	 * @param e ChannelJ݂ɕKvChannelOpenEvent
	 */
	public Behavior receiveOpenChannelEvent(OpenChannelEvent e) {
		return behaviorManager.receiveOpenChannelEvent(e);
	}

	/*****************
	* Goods֌W
	*****************/

	/**
	 * ǉ܂B
	 * @param goods ǉ
	 */
	public void addGoods(Goods goods) {
		goodsManager.addGoods(goods);
		this.fireGoodsAdded(new UpdateAgentEvent(this, goods));
	}

	/**
	 * w肳ꂽނ̍wʈo܂B
	 * w肳ꂽނ̍wʑ݂Ȃꍇ́AException܂B
	 * @param type o̎
	 * @param quantity o̗
	 * @return Goods oꂽ
	 */
	public Goods removeGoods(GoodsType type, double quantity) {
		Goods target = goodsManager.removeGoods(type, quantity);
		this.fireGoodsRemoved(new UpdateAgentEvent(this, target));
		return target;
	}

	/**
	 * w肳ꂽނ̍wʈo܂B
	 * w肳ꂽނɉʎނ΍ċAIɌ܂B
	 * w肳ꂽނ̍wʑ݂Ȃꍇ́AException܂B
	 * @param type o̎
	 * @param quantity o̗
	 * @return Goods oꂽ
	 */
	public Collection removeGoodsRecursively(GoodsType type, double quantity) {
		Collection target = goodsManager.removeGoodsRecursively(type, quantity);
		this.fireGoodsRemoved(new UpdateAgentEvent(this, target));
		return target;
	}

	/**
	 * w肳ꂽނׂ̍Ĉo܂B
	 * w肳ꂽނ݂̍Ȃꍇ́AException܂B	
	 * @param type o̎
	 * @return Goods oꂽ
	 */
	public Goods removeAllGoods(GoodsType type) {
		Goods target = goodsManager.removeAllGoods(type);
		this.fireGoodsRemoved(new UpdateAgentEvent(this, target));
		return target;
	}

	/**
	 * w肳ꂽނׂ̍Ĉo܂B
	 * w肳ꂽނɉʎނ΍ċAIɌ܂B
	 * w肳ꂽނ݂̍Ȃꍇ́AException܂B
	 * @param type o̎
	 * @return Goods oꂽ
	 */
	public Collection removeAllGoodsRecursively(GoodsType type) {
		Collection target = goodsManager.removeAllGoodsRecursively(type);
		this.fireGoodsRemoved(new UpdateAgentEvent(this, target));
		return target;
	}

	/**
	 * w肳ꂽނ̗̍ʂ擾܂B
	 * w肳ꂽނ̍0\GoodsQuantityCX^XԂ܂B
	 * @param type ׂ̎
	 * @return GoodsQuantity ̗
	 */
	public GoodsQuantity getQuantity(GoodsType type) {
		return goodsManager.getQuantity(type);
	}

	/**
	 * w肳ꂽނ̗̍ʂ擾܂B
	 * w肳ꂽނɉʎނ΍ċAIɌ܂B
	 * w肳ꂽނ̍0\GoodsQuantityCX^XԂ܂B
	 * @param type ׂ̎
	 * @return GoodsQuantity ̗ʂ̍v
	 */
	public GoodsQuantity getQuantityRecursively(GoodsType type) {
		return goodsManager.getQuantityRecursively(type);
	}

	/**
	 * w肳ꂽނ̍Ă邩ǂׂ܂
	 * @return boolean Ă邩ǂ
	 */
	public boolean hasGoods(GoodsType type) {
		return this.getQuantityRecursively(type).getValueAsDouble() > 0d;
	}

	/**
	 * AgentSĂ̍̎ނԂ܂
	 * @return Collection GoodsTypẽXg
	 */
	public Collection getGoodsTypes() {
		return goodsManager.getGoodsTypes();
	}

	/*****************
	 * Relation֌W
	 *****************/

	/**
	* ftHgType𗘗pRelationǉ܂B
	* @param relation ǉRelation
	*/
	public void addRelation(Agent target) {
		this.addRelation(FMFWConstants.RELATIONTYPE_DEFAULT, target);
	}

	/**
	* Relationǉ܂B
	* @param relation ǉRelation
	*/
	public void addRelation(RelationType relationType, Agent target) {
		Relation newRelation = new Relation(relationType, this, target);
		relationManager.addRelation(newRelation);
		this.fireRelationAdded(new UpdateAgentEvent(this, newRelation));
	}

	/**
	 * Relation폜܂B
	 * @param relation 폜ΏۂRelation
	 */
	public void removeRelation(Relation relation) {
		relationManager.removeRelation(relation);
		this.fireRelationRemoved(new UpdateAgentEvent(this, relation));
	}

	/**
	 * TypeRelationSĂ폜܂B
	 * @param type 폜ΏۂType
	 */
	public void removeRelations(RelationType type) {
		relationManager.removeRelations(type);
	}

	/**
	 * Typeyт̎qTypeRelationSĂ폜܂B
	 * @param type 폜ΏۂType
	 */
	public void removeRelationsRecursively(RelationType type) {
		this.relationManager.removeRelationsRecursively(type);
	}

	/**
	 * Agent̎RelationTypeԂ܂B
	 * A݂ȂException܂B
	 * @return Collection Relation̎TypẽXg
	 */
	public Collection getRelationTypes() {
		return relationManager.getRelationTypes();
	}

	/**
	 * TypełRelationԂ܂BiꍇAԍŏɒǉꂽRelationԂ܂j
	 * A݂ȂException܂B
	 * @param type ΏۂType
	 * @return Relation YRelation
	 */
	public Relation getRelation(RelationType type) {
		return relationManager.getRelation(type);
	}

	/**
	 * TypełrelationCollectionƂđSĕԂ܂B
	 * A݂Ȃ΋CollectionԂ܂
	 * @param type ΏۂType
	 * @return Collection YRelatioñXg
	 */
	public Collection getRelations(RelationType type) {
		return relationManager.getRelations(type);
	}

	/**
	 * Returns All Relations.
	 * @return Collection The collection which has all behaviors.
	 */
	public List getAllRelations() {
		return relationManager.getAllRelations();
	}

	/**
	 * TypeyтType̎qTypełSĂrelationԂ܂B
	 * A݂Ȃ΋CollectionԂ܂
	 * @param type ΏۂType
	 * @return Collection YRelatioñXg
	 */
	public Collection getRelationsRecursively(RelationType type) {
		return relationManager.getRelationsRecursively(type);
	}

	/**
	 * TypeA֌W悪AgentłRelationԂ܂
	 */
	public Relation getRelation(RelationType type, Agent agent) {
		return relationManager.getRelation(type, agent);
	}

	protected void fireGoodsAdded(UpdateAgentEvent e) {
		if (getWorld().getPresentationContainer() != null) {
			getWorld()
				.getPresentationContainer()
				.getUpdateEventManager()
				.goodsAdded(
				e);
		}
	}

	protected void fireGoodsRemoved(UpdateAgentEvent e) {
		if (getWorld().getPresentationContainer() != null) {
			getWorld()
				.getPresentationContainer()
				.getUpdateEventManager()
				.goodsRemoved(
				e);
		}
	}

	protected void fireInformationAdded(UpdateAgentEvent e) {
		if (getWorld().getPresentationContainer() != null) {
			getWorld()
				.getPresentationContainer()
				.getUpdateEventManager()
				.informationAdded(
				e);
		}
	}

	protected void fireInformationRemoved(UpdateAgentEvent e) {
		if (getWorld().getPresentationContainer() != null) {
			getWorld()
				.getPresentationContainer()
				.getUpdateEventManager()
				.informationRemoved(e);
		}
	}

	protected void fireRelationAdded(UpdateAgentEvent e) {
		if (getWorld().getPresentationContainer() != null) {
			getWorld()
				.getPresentationContainer()
				.getUpdateEventManager()
				.relationAdded(
				e);
		}
	}

	protected void fireRelationRemoved(UpdateAgentEvent e) {
		if (getWorld().getPresentationContainer() != null) {
			getWorld()
				.getPresentationContainer()
				.getUpdateEventManager()
				.relationRemoved(
				e);
		}
	}

	protected void fireBehaviorAdded(UpdateAgentEvent e) {
		if (getWorld().getPresentationContainer() != null) {
			getWorld()
				.getPresentationContainer()
				.getUpdateEventManager()
				.behaviorAdded(
				e);
		}
	}

	protected void fireBehaviorRemoved(UpdateAgentEvent e) {
		if (getWorld().getPresentationContainer() != null) {
			getWorld()
				.getPresentationContainer()
				.getUpdateEventManager()
				.behaviorRemoved(
				e);
		}
	}

	/*********************
	 * for serializing
	 ********************/
	//	private void writeObject(ObjectOutputStream stream) throws IOException {
	//		stream.defaultWriteObject();
	//		stream.writeObject(this.getType().getName());
	//	}
	//
	//	private void readObject(ObjectInputStream stream)
	//		throws IOException, ClassNotFoundException {
	//		stream.defaultReadObject();
	//		String name = (String) stream.readObject();
	//		this.type = this.getWorld().getAgentType(name);
	//	}

}
