/*
 * AgentManager.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelException;

/**
 * AgentǗ邽߂̃NXłB
 * AgentTypeɂAgentE폜C^[tF[X܂B
 * AgentTypełقȂCX^XAgentʂĊi[܂B
 * 
 * @author Mizutori
 * @version $Id: AgentManager.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class AgentManager implements Serializable {

	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(AgentManager.class.getName());

	//Agenti[܂BATypeAgentƍlāAList}܂B
	private HashMap agentMap = new LinkedHashMap();

	protected AgentManager() {
	}

	/**
	 * Agentǉ܂B
	 * @param newAgent ǉAgent
	 */
	public void addAgent(Agent newAgent) {
		this.addAgentToMap(newAgent);
	}

	/**
	 * Ɏw肵AgentXg폜܂B
	 * @param target 폜Agent
	 */
	public void removeAgent(Agent target) {
		this.removeAgentFromMap(target);
	}

	/**
	 * TypeAgentԂ܂BꍇAŏAgentԂ܂B
	 * Ȃ΁AExceptionԂ܂B
	 * @param type w肷AgentType
	 * @return Agent YAgent
	 */
	public Agent getAgent(AgentType type) {
		Collection c = this.getAgents(type);
		if (c.isEmpty()) {
			throw new ModelException(type.toString() + "is not existed !");
		}
		return (Agent) c.iterator().next();
	}

	/**	 
	 * TypeAgent̃XgԂ܂B
	 * Ȃ΁ÃXgԂ܂B
	 * @param type w肷AgentType
	 * @return Collection YAgent̏W
	 */
	public Collection getAgents(AgentType type) {
		logger.debug("IN");
		List value = (List) agentMap.get(type);
		if (value == null || value.isEmpty() || value.size() == 0) {
			logger.debug("OUT(No Agent)");
			return new ArrayList();
		}
		logger.debug("OUT");
		return new ArrayList(value);
	}

	/**
	 * Typeyт̎qTypeAgent̃XgԂ܂B
	 * Ȃ΁ÃXgԂ܂B
	 * @param type w肷AgentType
	 * @return List YAgent̏W
	 */
	public List getAgentsRecursively(AgentType type) {
		logger.debug("IN");
		List value = (List) getAgents(type);
		Iterator i = type.getChildrenRecursively().iterator();
		while (i.hasNext()) {
			AgentType t = (AgentType) i.next();
			value.addAll(getAgents(t));
		}
		logger.debug("OUT");
		return new ArrayList(value);
	}

	/**
	 * SĂAgent̏WԂ܂B
	 * @return List Agent̏W
	 */
	public List getAllAgents() {
		logger.debug("IN");
		List value = new ArrayList();
		Iterator i = agentMap.values().iterator();
		while (i.hasNext()) {
			List l = (List) i.next();
			value.addAll(l);
		}
		logger.debug("OUT");
		return new ArrayList(value);
	}

	/**
	* Mapɒǉ镔̂݁AprivateŒo
	* @param agent 
	*/
	private void addAgentToMap(Agent agent) {
		logger.debug("IN");
		List list = (List) agentMap.get(agent.getType());
		if (list != null) {
			if (list.contains(agent))
				list.remove(agent);
			list.add(agent);
		}
		else {
			list = new ArrayList();
			list.add(agent);
			agentMap.put(agent.getType(), list);
		}
		logger.debug("OUT");
	}

	/**
	 * Map폜镔̂݁AprivateŒo
	 * @param behavior
	 */
	private void removeAgentFromMap(Agent agent) {
		logger.debug("IN");
		List list = (List) agentMap.get(agent.getType());
		if (list != null) {
			if (list.contains(agent)) {
				list.remove(agent);
			}
			else {
				logger.debug("OUT(Exception");
				throw new ModelException("AbstractBehavior not found ! " + agent);
			}
		}
		else {
			throw new ModelException("AbstractBehavior Type not found ! " + agent);
		}
		logger.debug("OUT");

	}

}
