/*
 * Behavior.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.behavior.Event;
import org.boxed_economy.besp.model.fmfw.behavior.State;
import org.boxed_economy.besp.model.fmfw.update.UpdateBehaviorEvent;

/**
 *G[WFg̍sȂlXȍsBehaviorƂĒ`܂B 
 * behavior͏ԋ@BɂĎ܂BāAlXEvent󂯎܂B
 * AbehaviormodelɂăASY傫قȂ镔邽߁A
 * AuXgNgƂĒ񋟂܂BۃfɎgBehavior͂̃NXpč쐬ĂB
 * t[[NƂāAJnEIECxgMEChannelݒ̂߂̃C^[tF[X񋟂܂B
 * ܂AChannel݂ChannelсAƂł܂B
 * 
 * @author macchan
 * @version $Id: Behavior.java,v 1.2 2004/03/21 20:07:07 macchan Exp $
 */
public abstract class Behavior extends FmFwObject {

	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(Behavior.class.getName());

	private transient BehaviorType type = null; // BehaviorTypełB
	private Agent agent = null; // BehaviorAgent
	private ChannelManager channelManager = new ChannelManager();
	private ReceivedGoodsManager receivedGoodsManager =
		new ReceivedGoodsManager(this);

	/*****************
	 * Type֘A
	 *****************/

	/**
	 * Method getType.
	 * @return BehaviorType
	 */
	public BehaviorType getType() {
		return type;
	}

	/**
	 * Method setType.
	 * @param type
	 */
	public final void setType(BehaviorType type) {
		this.type = type;
	}

	/*****************
	 * Agent,World֘A
	 *****************/

	/**
	 * BehaviorĂAgentzuĂWorldԂ܂B
	 * @return World BehaviorzuĂ邱ƂɂȂWorld
	 */
	public World getWorld() {
		assert this.agent != null || this.agent.getWorld() != null;
		return this.agent.getWorld();
	}

	/**
	 * BehaviorAgentԂ܂B
	 * @return Agent BehaviorAgent
	 */
	public Agent getAgent() {
		assert this.agent != null;
		return this.agent;
	}

	/**
	 * BehaviorAgentݒ肵܂B
	 * BehaviorǉɁABehaviorManagerɂČĂ΂܂B
	 * @param agent BehaviorAgent
	 */
	final void setAgent(Agent agent) {
		this.agent = agent;
	}

	/**
	 * ݂̏Ԃ擾܂D
	 * @return
	 */
	public abstract State getState();

	/***************
	 * Channel֘A
	 ***************/

	/**
	 * BehaviorgJĂChannelԂ܂
	 */
	public Channel getActiveChannel() {
		return this.channelManager.getActiveChannel();
	}

	/**
	 * BehaviorɐVChannelݒ肵܂B
	 * AChannel݂ĂꍇAChannelڑۂ悤ɐݒ肳Ă
	 * ChannelListɊi[܂B
	 * @param channel ݒ肷Channel
	 */
	final void setActiveChannel(Channel channel) {
		this.channelManager.setActiveChannel(channel);
	}

	/**
	 * ChannelƂɁAChannelĂ΂܂B
	 * Xg邢́AcurrentChannelɈChannel΁A폜܂B
	 * @param channel 폜Channel
	 */
	final void removeChannel(Channel channel) {
		this.channelManager.removeChannel(channel);
	}

	/**
	 * ׂĂ̌oH擾܂
	 * @param channel
	 */
	public List getAllChannels() {
		return this.channelManager.getAllChannels();
	}

	/***************
	 * JnA~
	 ***************/

	/**
	 * ԋ@BJn邽߂̃\bhłB
	 * AgentBehaviorǉƂɌĂ΂܂B
	 */
	protected abstract void run();

	/**
	* ԋ@B~邽߂̃\bhłB
	* AgentBehavior폜OɌĂ΂܂B
	*/
	protected abstract void stop();

	/***************
	 * Event֘A
	 ***************/

	/**
	 * RelationChannel̊J݂Ɋւċ߂郁\bhłB
	 * OpenChannelEvent擾āAbooleanŕԂĂB
	 * @param e J݂߂Channel̏܂Event
	 * @return boolean J݂邩̐^U
	 */
	protected abstract boolean isReceivableEvent(Event e);

	/**
	 * ChannelAAgent瑗ꂽEvent󂯎郁\bhłB
	 * ݂́ATimeEvent,ChannelEvent,KillEvent̂Rނ̃Cxg󂯎܂B
	 * @param e ꂽCxghy
	 */
	protected abstract void receiveEvent(Event e);

	/*****************************************
	 * M֘A
	 ******************************************/

	/**
	 * 𑗐M܂
	 * ɊJĂChannel𗘗p܂
	 * JĂChannelȂꍇAException𓊂܂
	 */
	public final void sendGoods(Goods goods) {
		Channel channel = this.getActiveChannel();
		if (channel == null) {
			throw new ModelException("cannot sendGoods because channel is null");
		}

		channel.sendGoods(goods, this);
	}

	/**
	 * 𑗐M܂
	 * ֌Ww肵܂iIChannelJ܂j
	 */
	public final void sendGoods(
		Relation relation,
		BehaviorType behaviorType,
		Goods goods,
		boolean keep) {
		boolean opened = relation.openChannel(this, behaviorType, keep);
		if (opened) {
			this.sendGoods(goods);
		}
	}

	/**
	 * 𑗐M܂
	 * ֌Ww肵܂(Ikeep=falseChannelJ܂)
	 */
	protected final void sendGoods(
		Relation relation,
		BehaviorType behaviorType,
		Goods goods) {
		this.sendGoods(relation, behaviorType, goods, false);
	}

	/**
	 * 𑗐M܂B
	 * ݊JĂChannel𗘗p܂
	 */
	public final void sendInformation(Information information) {
		this.sendGoods(this.createDefaultGoods(information));
	}

	/**
	 * 𑗐M܂B
	 * ֌Ww肵܂iIChannelJ܂j
	 */
	public final void sendInformation(
		Relation relation,
		BehaviorType behaviorType,
		Information information,
		boolean keep) {
		this.sendGoods(
			relation,
			behaviorType,
			this.createDefaultGoods(information),
			keep);
	}

	/**
	 * 𑗐M܂B
	 * ֌Ww肵܂iIkeep=falseChannelJ܂j
	 */
	public final void sendInformation(
		Relation relation,
		BehaviorType behaviorType,
		Information information) {
		this.sendInformation(relation, behaviorType, information, false);
	}

	/**
	 * 𑗐M܂B
	 * ֌W̃^Cvw肵܂iIkeep=falseChannelJ܂j
	 */
	public final int sendInformation(
		RelationType relationType,
		BehaviorType behaviorType,
		Information information) {
		return this.sendInformation(
			relationType,
			behaviorType,
			information,
			false);
	}

	/**
	 * 𑗐M܂B
	 * ֌W̃^Cvw肵܂iIChannelJ܂j
	 */
	public final int sendInformation(
		RelationType relationType,
		BehaviorType behaviorType,
		Information information,
		boolean keep) {
		int count = 0;
		Collection relations = this.getAgent().getRelations(relationType);
		Iterator i = relations.iterator();
		while (i.hasNext()) {
			Goods goods = this.createDefaultGoods(information);
			this.sendGoods((Relation) i.next(), behaviorType, goods, keep);
			count++;
		}
		return count;
	}

	/**
	 * ^Cvw肵āC𑗐M܂B
	 */
	public final void sendInformation(
		InformationType key,
		Information information) {
		this.sendGoods(this.createDefaultGoods(key, information));
	}

	/**
	 * ^Cvw肵āC𑗐M܂B
	 */
	public final int sendInformation(
		RelationType relationType,
		BehaviorType behaviorType,
		InformationType key,
		Information information,
		boolean keep) {
		int count = 0;
		Collection relations = this.getAgent().getRelations(relationType);
		Iterator i = relations.iterator();
		while (i.hasNext()) {
			Goods goods = this.createDefaultGoods(key, information);
			this.sendGoods((Relation) i.next(), behaviorType, goods, keep);
			count++;
		}
		return count;
	}

	/**
	 * DefaultGoodsType𐶐܂
	 */
	private Goods createDefaultGoods(
		InformationType key,
		Information information) {
		Goods goods = new Goods(FMFWConstants.GOODSTYPE_DEFAULT, 1);
		goods.setWorld(this.getWorld());
		goods.setAttachment(key, information);
		return goods;
	}

	/**
	 * DefaultGoodsType𐶐܂
	 */
	private Goods createDefaultGoods(Information information) {
		Goods goods = new Goods(FMFWConstants.GOODSTYPE_DEFAULT, 1);
		goods.setWorld(this.getWorld());
		goods.setAttachment(information);
		return goods;
	}

	/*****************************************
	 * M֗\bh֘A
	 * ̃\bh͕ς\܂
	 ******************************************/

	/**
	 * 𑗐M܂
	 */
	protected final int sendGoods(
		RelationType relationType,
		BehaviorType behaviorType,
		GoodsType goodsType,
		double goodsQuantity,
		boolean createGoods) {
		return this.sendGoods(
			relationType,
			behaviorType,
			goodsType,
			goodsQuantity,
			createGoods,
			false);
	}

	/**
	 * 𑗐M܂
	 */
	protected final int sendGoods(
		RelationType relationType,
		BehaviorType behaviorType,
		GoodsType goodsType,
		double goodsQuantity,
		boolean createGoods,
		boolean keep) {
		int count = 0;
		Collection relations = this.getAgent().getRelations(relationType);
		Iterator i = relations.iterator();
		while (i.hasNext()) {
			Goods goods = this.getGoods(goodsType, goodsQuantity, createGoods);
			this.sendGoods((Relation) i.next(), behaviorType, goods, keep);
			count++;
		}
		return count;
	}

	private Goods getGoods(
		GoodsType goodsType,
		double goodsQuantity,
		boolean createGoods) {
		if (createGoods) {
			return this.getWorld().createGoods(goodsType, goodsQuantity);
		} else {
			return this.getAgent().removeGoods(goodsType, goodsQuantity);
		}
	}

	/***********************************
	 * ֘A
	 * 󂯎ۊǂĂ
	 ***********************************/

	public void keepReceivedGoods() {
		this.receivedGoodsManager.keepReceivedGoods();
	}

	public void setReceivedGoods(ChannelEvent event) {
		this.receivedGoodsManager.setReceivedGoods(event);
	}

	public Goods getReceivedGoods() {
		return this.receivedGoodsManager.getReceivedGoods();
	}

	/***********************
	 * 󂯎֗\bh
	 ***********************/

	/**
	 * 񂾂󂯎邽߂֗̕\bh
	 */
	public Information getReceivedInformation() {
		Goods receivedGoods = getReceivedGoods();
		if (!receivedGoods.hasAttachment()) {
			throw new ModelException(
				"The goods ("
					+ receivedGoods
					+ ") is not attached information.");
		}
		return receivedGoods.getAttachment();
	}

	/**
	 * 󂯎ɕt񂪈ŗ^ꂽInformationTypeƓǂׂB 
	 */
	public boolean receivedInformationEquals(InformationType type) {
		Goods receivedGoods = getReceivedGoods();
		if (!receivedGoods.hasAttachment()) {
			return false;
		} else if (
			receivedGoods.getAttachmentKey() instanceof InformationType) {
			return receivedGoods.getAttachmentKey().equals(type);
		} else {
			return getWorld().getInformationType(
				receivedGoods.getAttachment()).equals(
				type);
		}
	}

	/**
	 * 󂯎ŗ^ꂽGoodsTypeƓǂׂB 
	 */
	public boolean receivedGoodsEquals(GoodsType type) {
		return getReceivedGoods().getType().equals(type);
	}

	/***********************************
	 * for event
	 ***********************************/

	public void firePrepareTimeEventReceive(UpdateBehaviorEvent e) {
		if (getWorld().getPresentationContainer() != null) {
			getWorld()
				.getPresentationContainer()
				.getUpdateEventManager()
				.prepareTimeEventReceive(e);
		}
	}

	public void fireTimeEventReceived(UpdateBehaviorEvent e) {
		if (getWorld().getPresentationContainer() != null) {
			getWorld()
				.getPresentationContainer()
				.getUpdateEventManager()
				.timeEventReceived(
				e);
		}
	}

	public void fireStateChanged(UpdateBehaviorEvent e) {
		if (getWorld().getPresentationContainer() != null) {
			getWorld()
				.getPresentationContainer()
				.getUpdateEventManager()
				.stateChanged(
				e);
		}
	}

	public void fireTransitionStarted(UpdateBehaviorEvent e) {
		if (getWorld().getPresentationContainer() != null) {
			getWorld()
				.getPresentationContainer()
				.getUpdateEventManager()
				.transitionStarted(
				e);
		}
	}

	/*********************
	 * for serializing
	 ********************/
	//	private void writeObject(ObjectOutputStream stream) throws IOException {
	//		stream.defaultWriteObject();
	//		stream.writeObject(this.getType().getName());
	//	}
	//
	//	private void readObject(ObjectInputStream stream)
	//		throws IOException, ClassNotFoundException {
	//		stream.defaultReadObject();
	//		String name = (String) stream.readObject();
	//		this.type = this.getWorld().getBehaviorType(name);
	//	}

}
