/*
 * BehaviorManager.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelException;

/**
 * Agent̎behaviorǗ܂BiTOIɂ̓G[WFgɊ܂܂܂Bj
 * BehaviorTypeƂɕނĊi[܂Bi^Cv̈قȂBehaviorObjectʁXɊi[܂Bj
 * behaviorJnEIEC^[tF[X܂B
 * 
 * @author macchan
 * @version $Id: BehaviorManager.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class BehaviorManager implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(BehaviorManager.class.getName());

	//Behaviori[܂BATypeBehaviorƍlāAList}܂B
	private Agent agent;
	private HashMap behaviorMap = new LinkedHashMap();

	/**
	 * RXgN^łBBehaviorǉɕKvAgent^܂B
	 * @param newAgent Agent
	 */
	protected BehaviorManager(Agent agent) {
		logger.debug("IN");

		this.agent = agent;

		logger.debug("OUT");
	}

	/**
	 * BehaviorJnĒǉ܂B̍ۂɁABehaviorAgentZbg܂B
	 * @param newBehavior VǉBehavior
	 */
	public void addBehavior(Behavior behavior) {
		logger.debug("IN");

		behavior.setAgent(agent);
		this.addBehaviorToMap(behavior);

		logger.debug("OUT");
	}

	/**
	 * BehaviorIč폜܂B
	 * @param target 폜Behavior
	 */
	public void removeBehavior(Behavior behavior) {
		logger.debug("IN");

		behavior.stop();
		this.removeBehaviorFromMap(behavior);
		//behavior.setAgent(null);

		logger.debug("OUT");
	}

	/**
	 * TypełBehaviorԂ܂B(݂ĂꍇAŏ̂PԂ܂B)
	 * A݂ȂException܂B
	 * @param type ΏۂType
	 * @return Collection YBehavior̃Xg
	 */
	public Behavior getBehavior(BehaviorType type) {
		Collection c = getBehaviors(type);
		if (c.isEmpty())
			throw new ModelException(type.toString() + "is not existed !");
		return (Behavior) c.iterator().next();
	}

	/**
	 * TypełBehaviorXgƂđSĕԂ܂B
	 * A݂Ȃ΋̃XgԂ܂B
	 * @param type ΏۂType
	 * @return List YRelatioñXg
	 */
	public Collection getBehaviors(BehaviorType type) {
		logger.debug("IN");

		List value = (List) behaviorMap.get(type);
		if (value == null || value.isEmpty()) {
			return new ArrayList();
		}

		logger.debug("OUT");
		return new ArrayList(value);
	}

	/**
	 * Typeyт̎q^CvłrelationXgƂđSĕԂ܂B
	 * A݂Ȃ΋̃XgԂ܂B
	 * @param type ΏۂType
	 * @return List YBehavior̃Xg
	 */
	public Collection getBehaviorsRecursively(BehaviorType type) {
		logger.debug("IN");
		Collection value = getBehaviors(type);
		Iterator i = type.getChildrenRecursively().iterator();
		while (i.hasNext()) {
			BehaviorType t = (BehaviorType) i.next();
			value.addAll(getBehaviors(t));
		}
		logger.debug("OUT");
		return new ArrayList(value);
	}

	/**
	 * Returns All Behaviors.
	 * @return Collection The collection which has all behaviors.
	 */
	public List getAllBehaviors() {
		List behaviors = new ArrayList();
		Collection behaviorsLists = this.behaviorMap.values();
		for (Iterator i = behaviorsLists.iterator(); i.hasNext();) {
			List behaviorsList = (List) i.next();
			for (Iterator j = behaviorsList.iterator(); j.hasNext();) {
				Behavior element = (Behavior) j.next();
				behaviors.add(element);
			}
		}
		return behaviors;
	}

	/**
	 * ChannelJ݂邽߂ChannelOpenEvent󂯎郁\bhłB
	 * ChannelEvent󂯎BehaviorŏIIɕԂ܂B
	 * @param e ChannelJ݂ɕKvChannelOpenEvent
	 */
	public Behavior receiveOpenChannelEvent(OpenChannelEvent e) {
		logger.debug("IN");

		List behaviors =
			(List) this.getBehaviorsRecursively(e.getTargetBehaviorType());
		Iterator i = behaviors.iterator();
		while (i.hasNext()) {
			Behavior b = (Behavior) i.next();
			if (b.isReceivableEvent(e)) {
				return b;
			}
		}

		return behaviors.isEmpty() ? null : (Behavior) behaviors.get(0);
	}

	/**
	* TimeEvent󂯎邽߂̃\bhłB
	* TimeEventBehaviorփu[hLXg܂B
	* íAAgentłBehavior̗D揇ʂȂǂł܂A
	* ݂͂܂ł͍s܂j
	* @param e TimeEvent
	*/
	public void receiveTimeEvent(TimeEvent e) {
		logger.debug("IN");
		Iterator i = getAllBehaviorList().iterator();
		while (i.hasNext()) {
			Behavior b = (Behavior) i.next();
			b.receiveEvent(e);
		}
		logger.debug("OUT");
	}

	/**
	* SĂBehavior폜܂BAgent폜AgentĂ΂܂B
	*/
	public void removeAllBehaviors() {
		logger.debug("IN");
		Iterator i = getAllBehaviorList().iterator();
		while (i.hasNext()) {
			Behavior b = (Behavior) i.next();
			b.receiveEvent(new DeathEvent(this));
			removeBehavior(b);
		}
		logger.debug("OUT");
	}

	/**
	 * HashMap+ListłBehaviorQ̃XgɂĕԂ܂B
	 * Xg̊evfBehaviorłB
	 */
	private List getAllBehaviorList() {
		logger.debug("IN");
		List value = new ArrayList();
		Iterator i = behaviorMap.values().iterator();
		while (i.hasNext()) {
			List l = (List) i.next();
			value.addAll(l);
		}
		logger.debug("OUT");
		return new ArrayList(value);
	}

	/**
	* Mapɒǉ镔̂݁Aprivateł܂Ƃ߂܂B
	* @param behavior
	*/
	private void addBehaviorToMap(Behavior behavior) {
		logger.debug("IN");
		List list = (List) behaviorMap.get(behavior.getType());
		if (list != null) {
			if (list.contains(behavior))
				list.remove(behavior);
		} else {
			list = new ArrayList();
			behaviorMap.put(behavior.getType(), list);
		}
		list.add(behavior);

		logger.debug("OUT");
	}

	/**
	 * Map폜镔̂݁Aprivateł܂Ƃ߂܂B
	 * @param behavior
	 */
	private void removeBehaviorFromMap(Behavior behavior) {
		logger.debug("IN");
		List list = (List) behaviorMap.get(behavior.getType());
		if (list != null) {
			if (list.contains(behavior)) {
				list.remove(behavior);
			} else {
				logger.debug("OUT(Exception)");
				throw new ModelException(
					"AbstractBehavior not found ! " + behavior);
			}
		} else {
			throw new ModelException(
				"AbstractBehavior Type not found ! " + behavior);
		}
		logger.debug("OUT");

	}

}
