/*
 * Channel.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.model.fmfw;

import java.util.ArrayList;
import java.util.Collection;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.update.TradeEvent;
import org.boxed_economy.besp.model.fmfw.update.UpdateChannelEvent;
import org.boxed_economy.besp.presentation.PresentationContainer;

/**
 * agentgoods𑗂邽߂relation琶Channel`܂B
 * sendGoods()s邱ƂɂāAMBehaviorChannelEvent܂B
 * ́AǂBehaviorsł邽ߑoChannelEvent𑗂邱Ƃł܂B
 * AChannelł́Aʂ̂ChannelChannelBehaviorƂɂ܂B
 * Ƃ肳ꂽGoods͕āAi[CloseTradeEventƂđ܂B
 * 
 * @author macchan
 * @version $Id: Channel.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public final class Channel extends FmFwObject {

	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(Channel.class.getName());

	private Relation parentRelation = null;
	private Behavior behaviorA = null;
	private Behavior behaviorB = null;

	private Goods sendingGoods = null;
	private Collection goodsFromBehaviorA = new ArrayList();
	private Collection goodsFromBehaviorB = new ArrayList();

	private boolean keep = false;
	private boolean closed = false;

	/**
	 * RXgN^łB
	 * @param parentRelation Channel𐶂ݏoRelation
	 * @param channelStart Channel
	 * @param channelEnd Channel
	 * @param keepConnect ChannelBehaviorɂĕۑ邩
	 */
	protected Channel(
		Relation parentRelation,
		Behavior behaviorA,
		Behavior behaviorB,
		boolean keep) {
		this.parentRelation = parentRelation;
		this.behaviorA = behaviorA;
		this.behaviorB = behaviorB;
		this.keep = keep;
	}

	/**
	 * Channel𐶐RelationԂ܂B
	 * @return Relation Channel𐶐Relation
	 */
	public Relation getParentRelation() {
		return this.parentRelation;
	}

	/**
	* Channel̐BehaviorԂ܂B
	* @return AbstractBehavior channel̐Behavior
	*/
	public Behavior getBehaviorB() {
		return this.behaviorB;
	}

	/**
	 * ChanneľBehaviorԂ܂B
	 * @return AbstractBehavior channeľBehavior
	 */
	public Behavior getBehaviorA() {
		return this.behaviorA;
	}

	/**
	 * ChannelBehaviorɂKeep邩Ԃ܂B
	 * @return Channel Keep邩̐^U
	 */
	public boolean isKeep() {
		return this.keep;
	}

	/**
	 * Returns the closed.
	 * @return boolean
	 */
	public boolean isClosed() {
		return closed;
	}

	/**
	 * Channel܂BBehaviorĂ΂܂B
	 * ̎ATradeEvent܂B
	 */
	public void close() {
		logger.debug("IN");
		this.behaviorA.removeChannel(this);
		this.behaviorB.removeChannel(this);
		this.parentRelation.removeChannel(this);
		this.closed = true;
		this.fireTradeCompleted(
			new TradeEvent(
				this,
				this.goodsFromBehaviorA,
				this.goodsFromBehaviorB,
				this.parentRelation));
	}

	/**
	 * ChannelGoods󂯎郁\bhłB
	 * ChannelEventꂽBehaviorĂ΂܂B
	 * ̃\bhĂ΂ƁAChannelGoods͊i[܂B
	 * @param behavior 󂯎Behavior
	 * @return Goods MꂽGoods
	 */
	public Goods receiveGoods(Behavior behavior) {
		logger.debug("IN");
		if (this.closed) {
			throw new ModelException("receiveGoods called in illegal state (closed)");
		}
		if (behavior != this.behaviorA && behavior != this.behaviorB) {
			throw new ModelException("illegal behavior in receiveGoods");
		}

		Behavior targetBehavior = null;
		Behavior sourceBehavior = null;
		if (behavior == this.behaviorA) {
			sourceBehavior = this.behaviorB;
			targetBehavior = this.behaviorA;
		} else if (behavior == this.behaviorB) {
			sourceBehavior = this.behaviorA;
			targetBehavior = this.behaviorB;
		}

		Collection goodsList = null;
		if (behavior == behaviorB) {
			goodsList = this.goodsFromBehaviorA;
		} else if (behavior == behaviorA) {
			goodsList = this.goodsFromBehaviorB;
		}
		goodsList.add(this.sendingGoods);
		this.fireGoodsReceive(
			new UpdateChannelEvent(
				this,
				this.sendingGoods,
				sourceBehavior,
				targetBehavior));

		Goods returnGoods = sendingGoods;
		this.sendingGoods = null;
		return returnGoods;
	}

	/**
	 * GoodsM̂߂Ɏs郁\bhłB
	 * QBehavior𒲂ׂāAChannelłChannelɁA
	 * ChannelłChannelɑ܂B
	 * ǂłȂ΁AExceptionԂ܂B
	 */
	public void sendGoods(Goods goods, Behavior behavior) {
		logger.debug("IN");
		if (this.closed) {
			throw new ModelException("sendGoods called in illegal state (closed)");
		}
		if (behavior != this.behaviorA && behavior != this.behaviorB) {
			throw new ModelException("illegal behavior in sendGoods");
		}

		this.sendingGoods = goods;

		Behavior targetBehavior = null;
		Behavior sourceBehavior = null;
		if (behavior == this.behaviorA) {
			sourceBehavior = this.behaviorA;
			targetBehavior = this.behaviorB;
		} else if (behavior == this.behaviorB) {
			sourceBehavior = this.behaviorB;
			targetBehavior = this.behaviorA;
		}

		this.fireGoodsSend(
			new UpdateChannelEvent(
				this,
				goods,
				sourceBehavior,
				targetBehavior));
		targetBehavior.receiveEvent(new ChannelEvent(this));
	}

	private void fireTradeCompleted(TradeEvent event) {
		if (this.getContainer() != null) {
			this.getContainer().getUpdateEventManager().tradeCompleted(event);
		}
	}

	private void fireGoodsSend(UpdateChannelEvent event) {
		if (this.getContainer() != null) {
			this.getContainer().getUpdateEventManager().goodsSent(event);
		}
	}

	private void fireGoodsReceive(UpdateChannelEvent event) {
		if (this.getContainer() != null) {
			this.getContainer().getUpdateEventManager().goodsReceive(event);
		}
	}

	private PresentationContainer getContainer() {
		return this
			.getParentRelation()
			.getSource()
			.getWorld()
			.getPresentationContainer();
	}

}
