/*
 * ChannelManager.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;

/**
 * @author macchan
 * @version $Id: ChannelManager.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class ChannelManager implements Serializable {

	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(ChannelManager.class.getName());

	private List keptChannels = new ArrayList(); //BehaviorkeepĂChannel
	//BehaviorkeepĂChannelStack
	private ChannelStack channelStack = new ChannelStack();
	private Channel activeChannel = null; //BehaviorChannel

	/**
	 * Constructor for ChannelManager.
	 */
	protected ChannelManager() {
		super();
	}

	/**
	 * BehaviorgJĂChannelԂ܂
	 */
	public Channel getActiveChannel() {
		return this.activeChannel;
	}

	/**
	 * BehaviorɐVChannelݒ肵܂B
	 * AChannel݂ĂꍇAChannelڑۂ悤ɐݒ肳Ă
	 * ChannelListɊi[܂B
	 * @param channel ݒ肷Channel
	 */
	public void setActiveChannel(Channel channel) {
		if (this.activeChannel != null) {
			this.vacateCurrentChannel();
		}
		this.activeChannel = channel;
	}

	private void vacateCurrentChannel() {
		if (this.activeChannel.isKeep()) {
			this.keptChannels.add(this.activeChannel);
			this.channelStack.push(this.activeChannel);
		} else {
			this.activeChannel.close();
		}
	}

	/**
	 * ׂĂ̌oH擾܂
	 * @param channel
	 */
	public List getAllChannels() {
		List channels = new ArrayList(keptChannels);
		if (activeChannel != null) {
			channels.add(activeChannel);
		}
		return channels;
	}

	/**
	 * ChannelƂɁAChannelĂ΂܂B
	 * Xg邢́AcurrentChannelɈChannel΁A폜܂B
	 * @param channel 폜Channel
	 */
	public void removeChannel(Channel channel) {
		if (this.activeChannel == channel) {
			this.activeChannel = this.channelStack.pop();
		}
		if (this.keptChannels.contains(channel)) {
			this.keptChannels.remove(channel);
		}
		this.channelStack.remove(channel);
	}

	/**
	 * KeepꂽCChannel߂ĂX^bN
	 * ActiveChannelclose()ꂽƂɁC
	 * X^bN̍ŏChannelActiveɂȂ܂B
	 */
	class ChannelStack implements Serializable {
		private LinkedList list = new LinkedList();

		public void push(Channel channel) {
			list.addLast(channel);
		}

		public Channel pop() {
			if (list.isEmpty()) {
				return null;
			}
			return (Channel) list.removeLast();
		}

		public void remove(Channel channel) {
			if (list.contains(channel)) {
				list.remove(channel);
			}
		}
	}

}
