/*
 * Clock.java
 *
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.model.fmfw;

import java.io.Serializable;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.fmfw.update.UpdateClockEvent;

/**
 * WorldɂĕێAworldB̎vłB
 * ModelThreadɂĎo߂܂B
 * ܂AClockvKu|CgɂāAf̎Ԃ`ł܂B
 * (m̃pbP[Worg.boxex_economy.realclock܂B)
 * 
 * @author rx78g
 * @version $Id: Clock.java,v 1.3 2004/03/21 23:33:02 macchan Exp $
 */
public abstract class Clock implements Serializable {

	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(Clock.class.getName());

	private World world = null; //ClockzuĂWorld

	/******************************************
	 * v֘A
	 ******************************************/

	/**
	 * TimeEventModelThread瑗ꂽɎs܂B
	 * o߂̏͂̃\bhɎĂB
	 */
	public abstract void gain();

	/**
	 * ModelThread玞oߏŌĂ΂郁\bhłB
	 * @param e o߂Event
	 */
	public final void prepareStep() {
		logger.debug("IN");
		this.firePrepareStepStart(new UpdateClockEvent(this));
		logger.debug("OUT");
	}

	/**
	 * ModelThread玞oߏŌĂ΂郁\bhłB
	 * @param e o߂Event
	 */
	public final void receiveTimeEvent(TimeEvent e) {
		logger.debug("IN");

		this.gain();

		this.fireClockGained(new UpdateClockEvent(this));
		this.fireStepCompleted(new UpdateClockEvent(this));
		logger.debug("OUT");
	}

	/******************************************
	 * E֘A
	 ******************************************/

	/**
	 * ClockzuĂWorldݒ肵܂B
	 * @param world ݒ肷World
	 */
	public void setWorld(World world) {
		this.world = world;
	}

	/**
	* ClockzuĂWorldݒ肵܂B
	* @param world ݒ肷World
	*/
	public World getWorld() {
		return world;
	}

	/******************************************
	 * XV֘A
	 ******************************************/

	protected void firePrepareStepStart(UpdateClockEvent e) {
		if (world.getPresentationContainer() != null) {
			world
				.getPresentationContainer()
				.getUpdateEventManager()
				.prepareStepStart(
				e);
		}
	}

	protected void fireStepCompleted(UpdateClockEvent e) {
		if (world.getPresentationContainer() != null) {
			world
				.getPresentationContainer()
				.getUpdateEventManager()
				.stepCompleted(
				e);
		}
	}

	protected void fireClockGained(UpdateClockEvent e) {
		if (world.getPresentationContainer() != null) {
			world
				.getPresentationContainer()
				.getUpdateEventManager()
				.clockGained(
				e);
		}
	}

}
