/*
 * DefaultRandomNumberGenerator.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.model.fmfw;

import java.util.Random;

import org.apache.log4j.Logger;

/**
 * java.util.RandomNXɂĎRandomNumberGeneratorłB
 * 
 * @author rx78g
 * @version $Id: DefaultRandomNumberGenerator.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class DefaultRandomNumberGenerator implements RandomNumberGenerator {

	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(DefaultRandomNumberGenerator.class.getName());

	/**
	* randomNumberGeneratorAlgorithmłBRandom^łB
	*/
	private Random randomNumberGeneratorAlgorithm;

	/**
	* Random^ŗpÂ߂seedłB
	*/
	private long seed;

	/**
	* randomNumberGeneratorAlgorithmnamełB
	*/
	private String randomNumberGeneratorName = "";

	/**
	* RXgN^łBnameɉāARandomNX𐶐邽߂longseed
	* ^܂B
	* @param name Generator̖O
	* @param newSeed V[h
	*/
	public DefaultRandomNumberGenerator(String name, long newSeed) {
		logger.debug("IN");
		randomNumberGeneratorName = name;
		seed = newSeed;
		randomNumberGeneratorAlgorithm = new Random(seed);
		logger.debug("OUT");
	}

	/**
	* nameԂ܂B
	* @return ̃ASYname
	*/
	public String getName() {
		return randomNumberGeneratorName;
	}

	/**
	* Randomimplɏ],0ȏ`1܂łdoublevalueԂ܂B
	* @return ꂽ(0.00`0.99...)
	*/
	public double generate() {
		logger.debug("IN");
		double value = randomNumberGeneratorAlgorithm.nextDouble();
		logger.debug("OUT");
		return value;
	}

	/**
	* Randomimplɏ],0ȏ`1܂łdoubleɈ̍ővalue
	* ĕԂ܂B
	* @return ꂽ
	*/
	public int generate(int maxValue) {
		logger.debug("IN");
		double value = randomNumberGeneratorAlgorithm.nextDouble();
		int retValue = (int) (maxValue * value);
		logger.debug("OUT");
		return retValue;
	}

	/**
	* seedvalueRandomgenerateȂ܂B
	*/
	public void initialize() {
		randomNumberGeneratorAlgorithm = new Random(seed);
	}

	/**
	 * Returns the randomNumberGeneratorAlgorithm.
	 * @return Random
	 */
	public Random getRandom() {
		return randomNumberGeneratorAlgorithm;
	}

}
