/*
 * Entity.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw;

import java.util.Map;

import org.apache.log4j.Logger;

/**
 * InformationManagerNXłB
 * GoodsAgent̋ʂ̐eNXƂȂ܂B
 * 
 * @author macchan
 * @version $Id: Entity.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public abstract class Entity extends FmFwObject {

	private static final long serialVersionUID = 1L;
	private static final Logger logger = Logger.getLogger(Entity.class.getName());

	private World world = null; //AgentzuĂWorldłB
	private InformationManager informationManager = new InformationManager();

	/********************************************
	 * World֘A
	 ********************************************/

	/**
	 * AgentWorldɔzu邽߁AWorldĂ΂܂B
	 * @param newWorld zuWorld
	 */
	protected void setWorld(World newWorld) {
		world = newWorld;
	}

	/**
	 * AgentzuĂWorldԂ܂B
	 * {̖OgetWorld_newł͂ȂAgetWorldłAڍŝ߂ȂĂ܂B
	 */
	public World getWorld() {
		return world;
	}

	/********************************************
	 * Information֘A
	 ********************************************/

	/**
	 * Informationǉ܂BKeyInformationw肵ĂB
	 * @param key L[Information
	 * @param value lInformation
	 */
	public void putInformation(Information key, Information value) {
		this.informationManager.putInformation(key, value);
	}

	/**
	 * Informationǉ܂
	 * @param value lInformation
	 */
	public void putInformation(Information value) {
		this.informationManager.putInformation(
			this.getWorld().getInformationType(value),
			value);
	}

	/**
	 * InformationTypeƈvInformation(cloneł͂܂)Ԃ܂
	 * InformationȂꍇAExceptionԂ܂B
	 * @param key
	 * @return Information
	 */
	public Information getInformation(Information key) {
		return this.informationManager.getInformation(key);
	}

	/**
	 * ClassƈvInformation(cloneł͂܂)Ԃ܂
	 * InformationȂꍇAExceptionԂ܂B
	 * @param key
	 * @return Information
	 */
	public Information getInformation(Class informationClass) {
		return this.informationManager.getInformation(
			this.getWorld().getInformationType(informationClass.getName()));
	}

	/**
	 * InformationTypeƈvInformation폜܂B
	 * InformationȂꍇAExceptionԂ܂B
	 * @param key
	 * @return Information 폜Information
	 */
	public Information removeInformation(Information key) {
		return this.informationManager.removeInformation(key);
	}

	/**
	 * InformationTypeƈvInformation(cloneł͂܂)Ԃ܂
	 * InformationȂꍇAExceptionԂ܂B
	 * @param key
	 * @return Information
	 */
	public boolean hasInformation(Information key) {
		return this.informationManager.getInformations().containsKey(key);
	}

	/**
	 * IɊǗĂHashMapԂ܂B
	 * ̏Goods̕Aɂ̂ݎg܂B
	 * ̕ł͎gȂ悤ɂĂB
	 * @return Map i[ĂInformation
	 */
	public Map getInformations() {
		return this.informationManager.getInformations();
	}

	/**
	* IɊǗĂHashMapݒ肵܂B
	* ̏Goods̕Aɂ̂ݎg܂B
	* ̕ł͎gȂ悤ɂĂB
	* @param map ݒ肷MAP
	*/
	public void setInformations(Map map) {
		this.informationManager.setInformations(map);
	}

}
