/*
 * FMFWConstants.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw;

import org.boxed_economy.besp.model.ModelContainer;

/**
 * Default̒萔NXł
 * @author macchan
 * @version $Id: FMFWConstants.java,v 1.2 2004/03/21 20:07:07 macchan Exp $
 */
public class FMFWConstants {

	private static final String AGENTTYPE_KEY_DEFAULT = "defaultAgent";
	private static final String GOODSTYPE_KEY_DEFAULT = "defaultGoods";
	private static final String RELATIONTYPE_KEY_DEFAULT = "defaultRelation";

	public static AgentType AGENTTYPE_DEFAULT = null;
	public static GoodsType GOODSTYPE_DEFAULT = null;
	public static RelationType RELATIONTYPE_DEFAULT = null;

	public static final String RANDOM_DEFAULT = "defaultRandom";
	public static final String RANDOM_TIMEEVENT = "timeEventRandom";

	public static void initialize(ModelContainer container) {
		AGENTTYPE_DEFAULT = container.installAgentType(AGENTTYPE_KEY_DEFAULT);
		GOODSTYPE_DEFAULT = container.installGoodsType(GOODSTYPE_KEY_DEFAULT);
		RELATIONTYPE_DEFAULT =
			container.installRelationType(RELATIONTYPE_KEY_DEFAULT);
	}

}
