/*
 * FmFwObject.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * @author macchan
 * @version $Id: FmFwObject.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class FmFwObject implements Serializable {

	private static Map instanceCounters = new TreeMap();

	public static final List getInstanceCounters() {
		return new ArrayList(instanceCounters.values());
	}

	/**
	 * Constructor for FmFwObject.
	 */
	public FmFwObject() {
		getCounter().created();
	}

	/**
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		getCounter().destroyed();
	}

	private InstanceCounter getCounter() {
		String key = getClass().getName();
		if (!instanceCounters.containsKey(key)){
			instanceCounters.put(key, new InstanceCounter(getClass()));
		}
		return (InstanceCounter) instanceCounters.get(key);
	}

	public class InstanceCounter {
		private String name = null;
		private long alive = 0;
		private long allocated = 0;

		public InstanceCounter(Class clazz) {
			this.name = clazz.getName();
		}

		public void created() {
			alive++;
			allocated++;
		}

		public void destroyed() {
			alive--;
		}

		public String getName() {
			return name;
		}

		public long getAlive() {
			return alive;
		}

		public long getAllocated() {
			return allocated;
		}
	}

}
