/*
 * Goods.java
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.model.fmfw;

import org.apache.log4j.Logger;

/**
 * Boxed EconomybfɂăG[WFgԂŎ`܂B
 * ႦΕiݕłAagent̎SĂ܂ނ̂ƂĐȂǂgoodsłB
 * Goods̑ƂẮAType()AQuantity(),InformationijłB
 * ̏邱Ƃł悤ɂȂ܂B
 * goods͂QdQƂh߂ɓȈĂ܂̂ŁAGoods̈ɂ͗ӂĂB
 * igoodsManagerQƁjgoods͌p邱ƂOɂĂ܂B
 * worldcreateGoods(),consumeGoods()
 * gƂɂāAYEƂĖIUpdateEvent𑗂邱Ƃł܂B
 * 
 * @author macchan
 * @version $Id: Goods.java,v 1.2 2004/03/21 20:07:07 macchan Exp $
 */
public final class Goods extends Entity {

	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(Goods.class.getName());

	private GoodsType type = null;
	private GoodsQuantity goodsQuantity = null;

	private Information attachmentKey = new Attachment();

	/**
	 * ʏgRXgN^łB
	 * @param type Goods̎
	 * @param quantity Goods̗
	 */
	protected Goods(GoodsType type, double quantity) {
		this.type = type;
		this.goodsQuantity = new GoodsQuantity(quantity);
	}

	/**
	 * GoodsTypeԂ܂
	 * @return GoodsType Goods̎
	 */
	public GoodsType getType() {
		return this.type;
	}

	/**
	 * GoodsQuantityԂ܂
	 * @return GoodsQuantity Goods̗
	 */
	public GoodsQuantity getGoodsQuantity() {
		return new GoodsQuantity(this.goodsQuantity.getValueAsDouble());
	}

	/***********
	 * Attachment֌W
	 ***********/

	/**
	 * Returns the attachment.
	 * @return Information
	 */
	public Information getAttachment() {
		return this.getInformation(attachmentKey);
	}

	/**
	 * Sets the attachment.
	 * @param attachment The attachment to set
	 */
	public void setAttachment(Information attachment) {
		this.attachmentKey = new Attachment();
		this.putInformation(attachmentKey, attachment);
	}

	/**
	 * Sets the attachment.
	 * @param attachment The attachment to set
	 */
	public void setAttachment(InformationType key, Information attachment) {
		this.attachmentKey = key;
		this.putInformation(attachmentKey, attachment);
	}

	/**
	 * Returns if the goods has the attachment information.
	 */
	public boolean hasAttachment() {
		return super.hasInformation(attachmentKey);
	}

	public Information getAttachmentKey() {
		return attachmentKey;
	}

	/**
	 * ^CṽIuWFNgƃNX𕶎ŕԂ܂D
	 * toStringI[o[Ch܂B
	 */
	public String toString() {
		return this.type.getName()
			+ "("
			+ this.goodsQuantity.getValueAsDouble()
			+ ")";
	}

	/*******************
	* for serializing
	********************/
	//	private void writeObject(ObjectOutputStream stream) throws IOException {
	//		stream.defaultWriteObject();
	//		stream.writeObject(this.getType().getName());
	//	}
	//
	//	private void readObject(ObjectInputStream stream)
	//		throws IOException, ClassNotFoundException {
	//		stream.defaultReadObject();
	//		String name = (String) stream.readObject();
	//		this.type = this.getWorld().getGoodsType(name);
	//	}

	/**************
	 * inner classes
	 **************/

	/**
	 * attachmentł邱Ƃ`Information`܂B
	 * getAttachment,setAttachmentŗp܂B
	 */
	class Attachment implements Information {
	}

	/**
	 * @see java.lang.Object#finalize()
	 */
	protected void finalize() throws Throwable {
		super.finalize();
	}

}
