/*
 * GoodsManager.java
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.model.fmfw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelException;

/**
 * GoodsTypeL[ɂHashMapŊǗ܂B
 * TypeGoods̃CX^XGoodsManagerł͕KPłB
 * ǉ̍ۂɂGoods̈ꗗ𒲂ׁATypeGoods͈ɂ܂Ƃ߂܂B
 * o̍ۂɂ́AGoodsquantity𒲂ׂāAoGoods̗ʂ葽
 * VɈoquantityGoods𐶐ĕԂ܂B
 * 
 * @author macchan
 * @version $Id: GoodsManager.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class GoodsManager implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(GoodsManager.class.getName());

	private HashMap goodsHashMap = new HashMap();

	protected GoodsManager() {
	}

	/**
	 * Goodsǉ܂B
	 * GoodsQuantity.getValue()̏ꍇAException𓊂܂
	 * GoodsTypeꍇAGoodsGoodsQuantityɒǉ܂
	 * @param goods ǉ
	 */
	public void addGoods(Goods goods) {
		logger.debug("IN");
		// GoodsQuantity.getValue()̏ꍇAException𓊂܂
		if (goods.getGoodsQuantity().getValueAsDouble() < 0) {
			logger.debug("OUT(Exception)");
			throw new ModelException("GoodsQuantity cannot be negative value.");
		}
		//	 GoodsTypeꍇAGoodsGoodsQuantity𑝂₵Ė߂܂
		if (this.goodsHashMap.containsKey(goods.getType())) {
			Goods addGoods = (Goods) this.goodsHashMap.remove(goods.getType());
			this.goodsHashMap.put(
				addGoods.getType(),
				this.compositeGoods(
					addGoods,
					goods.getGoodsQuantity().getValueAsDouble()));
		}
		//GoodsTypeȂꍇÂ܂goodsHashMapɓ܂
		else {
			this.goodsHashMap.put(goods.getType(), goods);
		}
		logger.debug("OUT");
	}

	/**
	 * w肳ꂽނ̍wʈo܂B
	 * oꂽʁAGoodsQuantity0ƂȂGoodsHashMapł܂
	 * typethis.goodsHashMapɑ݂Ȃꍇ́AException܂B
	 * w肳ꂽނ̍wʑ݂Ȃꍇ́AException܂B
	 * @param type o̎
	 * @param quantity o̗
	 * @return Goods oꂽ
	 */
	public Goods removeGoods(GoodsType type, double quantity) {
		logger.debug("IN");
		//typethis.goodsHashMapɑ݂Ȃꍇ́AException܂B
		if (!this.goodsHashMap.containsKey(type)) {
			throw new ModelException("GoodsType is not found.");
		}
		//w肳ꂽނ̍wʑ݂Ȃꍇ́AException܂B
		if (((Goods) this.goodsHashMap.get(type))
			.getGoodsQuantity()
			.getValueAsDouble()
			< quantity) {
			throw new ModelException("GoodsQuantity is not enough.");
		}

		Goods addGoods = (Goods) this.goodsHashMap.remove(type);
		//Quantity0傫Ƃ̂݁AGoodsHashmapɖ߂܂
		if (this
			.separateGoods(addGoods, quantity)
			.getGoodsQuantity()
			.getValueAsDouble()
			> 0.0) {
			this.goodsHashMap.put(type, this.separateGoods(addGoods, quantity));
		}
		Goods newGoods = new Goods(type, quantity);
		newGoods.setWorld(addGoods.getWorld());
		newGoods.setInformations(new HashMap(addGoods.getInformations()));
		logger.debug("OUT");
		//		return new Goods(type, quantity);
		return newGoods;
	}

	/**
	 * w肳ꂽނׂ̍Ĉo܂B
	 * w肳ꂽނ݂̍Ȃꍇ́AException܂B	
	 * @param type o̎
	 * @return Goods oꂽ
	 */
	public Goods removeAllGoods(GoodsType type) {
		logger.debug("IN");
		//typethis.goodsHashMapɑ݂Ȃꍇ́AException܂B
		if (!this.goodsHashMap.containsKey(type)) {
			throw new ModelException("GoodsType is not found.");
		}
		Goods returnGoods = (Goods) this.goodsHashMap.get(type);
		this.goodsHashMap.remove(type);
		logger.debug("OUT");
		return returnGoods;
	}

	/**
	 * w肳ꂽނ̗̍ʂ擾܂B
	 * w肳ꂽނ̍0\GoodsQuantityCX^XԂ܂B
	 * @param type ׂ̎
	 * @return GoodsQuantity ̗
	 */
	public GoodsQuantity getQuantity(GoodsType type) {
		logger.debug("IN");
		//w肳ꂽނ̍0\GoodsQuantityCX^XԂ܂B
		if (!this.goodsHashMap.containsKey(type)) {
			return new GoodsQuantity(0);
		}
		logger.debug("OUT");
		return new GoodsQuantity(
			((Goods) this.goodsHashMap.get(type))
				.getGoodsQuantity()
				.getValueAsDouble());
	}

	/**
	 * GoodsManagerSĂ̍̎ނԂ܂
	 * @return Collection GoodsTypẽXg
	 */
	public Collection getGoodsTypes() {
		return new HashSet(this.goodsHashMap.keySet());
	}

	/**
	 * w肳ꂽނ̍wʈo܂B
	 * w肳ꂽނɉʎނ΍ċAIɌ܂B
	 * w肳ꂽނ̍wʑ݂Ȃꍇ́AException܂B
	 * @param type o̎
	 * @param quantity o̗
	 * @return Goods oꂽ
	 */
	public List removeGoodsRecursively(GoodsType type, double quantity) {
		logger.debug("IN");
		ArrayList returnArray = new ArrayList();
		List types = type.getChildrenRecursively();
		types.add(type);
		Iterator i = types.iterator();
		while (i.hasNext()) {
			GoodsType goodsType = (GoodsType) i.next();
			Goods g = this.removeGoods(goodsType, quantity);
			returnArray.add(g);
		}

		if (returnArray.isEmpty()) {
			throw new ModelException("Any GoodsType cannot found." + type);
		}
		logger.debug("OUT");
		return returnArray;
	}

	/**
	 * w肳ꂽނׂ̍Ĉo܂B
	 * w肳ꂽނɉʎނ΍ċAIɌ܂B
	 * w肳ꂽނ݂̍Ȃꍇ́AremoveGoodsCollection()Exception܂B
	 * @param type o̎
	 * @return Goods oꂽ
	 */
	public Collection removeAllGoodsRecursively(GoodsType type) {
		logger.debug("IN");
		ArrayList returnArray = new ArrayList();
		Iterator i = type.getChildrenRecursively().iterator();
		while (i.hasNext()) {
			GoodsType t = (GoodsType) i.next();
			if (this.goodsHashMap.containsKey(t)) {
				returnArray.add(this.removeAllGoods(t));
			}
		}

		if (returnArray.isEmpty()) {
			throw new ModelException("Any GoodsType cannot found." + type);
		}
		logger.debug("OUT");
		return returnArray;
	}

	/**
	 * w肳ꂽނ̗̍ʂ擾܂B
	 * w肳ꂽނɉʎނ΍ċAIɌ܂B
	 * w肳ꂽނ̍0\GoodsQuantityCX^XԂ܂B
	 * @param type ׂ̎
	 * @return GoodsQuantity ̗ʂ̍v
	 */
	public GoodsQuantity getQuantityRecursively(GoodsType type) {
		logger.debug("IN");
		GoodsQuantity returnQuantity = new GoodsQuantity(0.0);
		if (this.goodsHashMap.containsKey(type)) {
			returnQuantity = returnQuantity.add(this.getQuantity(type));
		}
		Iterator i = type.getChildrenRecursively().iterator();
		while (i.hasNext()) {
			GoodsType goodsType = (GoodsType) i.next();
			returnQuantity = returnQuantity.add(this.getQuantity(goodsType));
		}
		logger.debug("OUT");
		return returnQuantity;
	}

	/**
	 * TypeGoods̃XgRecursiveɌĕԂ܂
	 * ݂ȂꍇÃXgԂ܂
	 */
	private Collection getGoodsCollectionRecursively(GoodsType type) {
		logger.debug("IN");
		Collection value = this.getGoodsCollection(type);
		Iterator i = type.getChildrenRecursively().iterator();
		while (i.hasNext()) {
			GoodsType t = (GoodsType) i.next();
			value.addAll(this.getGoodsCollection(t));
		}
		logger.debug("OUT");
		return new ArrayList(value);
	}

	/**
	 * TypeGoods̃XgԂ܂
	 * ݂ȂꍇÃXgԂ܂
	 */
	public Collection getGoodsCollection(GoodsType type) {
		logger.debug("IN");
		List value = (List) this.goodsHashMap.get(type);
		if (value == null || value.isEmpty()) {
			logger.debug("OUT");
			return new ArrayList();
		}
		else {
			logger.debug("OUT");
			return new ArrayList(value);
		}
	}

	/**
	 * TypeGoods̃Xgo܂
	 * ݂ȂꍇAException܂
	 */
	private Collection removeAllGoodsCollection(GoodsType type) {
		logger.debug("IN");
		List value = (List) this.goodsHashMap.remove(type);
		if (value == null || value.isEmpty()) {
			throw new ModelException("Goods not found ! " + type);
		}
		logger.debug("OUT");
		return new ArrayList(value);
	}

	/**
	 * ^Cv̍ĕԂ܂
	 * ^CvłȂꍇAException𓊂܂
	 * ?? GoodsInformation͂ǂ̂悤Ɉ̂ ??
	 * @param Goods Goods
	 * @return Goods
	 */
	private Goods compositeGoods(Goods goods, double addQuantity) {
		logger.debug("IN");
		double returnDouble =
			goods.getGoodsQuantity().getValueAsDouble() + addQuantity;
		Goods newGoods = new Goods(goods.getType(), returnDouble);
		newGoods.setWorld(goods.getWorld());
		newGoods.setInformations(new HashMap(goods.getInformations()));
		logger.debug("OUT");
		return newGoods;
	}

	/**
	 * quantitywl炵VԂ܂
	 * quantity}CiXɂȂꍇAException𓊂܂
	 * ?? GoodsInformation͂ǂ̂悤Ɉ̂ ??
	 * @param Goods Goods
	 * @return Goods
	 */
	private Goods separateGoods(Goods goods, double deleteQuantity) {
		logger.debug("IN");
		if (goods.getGoodsQuantity().getValueAsDouble() < deleteQuantity) {
			logger.debug("OUT(Exception)");
			throw new ModelException("GoodsQuantity cannot be negative value.");
		}
		double returnDouble =
			goods.getGoodsQuantity().getValueAsDouble() - deleteQuantity;
		Goods newGoods = new Goods(goods.getType(), returnDouble);
		newGoods.setWorld(goods.getWorld());
		newGoods.setInformations(new HashMap(goods.getInformations()));
		logger.debug("OUT");
		return newGoods;
	}

}
