/*
 * GoodsQuantity.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.model.fmfw;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelException;

/**
 * Goods̗ʂ`܂BquantityƂđsȂ߂addEremoveEequalsiquantitył邩̔rj
 * rsȂƂł܂BldoubleƂĎĂ܂B
 * ܂łgoodsquantity\NXƂĂ߂ɁAsetquantity͎܂B
 * 
 * @author macchan
 * @version $Id: GoodsQuantity.java,v 1.2 2004/03/21 20:07:07 macchan Exp $
 */
public class GoodsQuantity implements java.io.Serializable {

	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(GoodsQuantity.class.getName());

	/**
	* goodsquantity_(double)
	*/
	private double value = 0d;

	/**
	* RXgN^łBݒ肷goodsquantityKdoubleŗ^ĂB
	*/
	public GoodsQuantity(double value) throws ModelException {
		logger.debug("IN");
		if (value < 0.0) {
			// ̐goodsquantitycreate悤ƂꍇAexceptionԂ܂B
			throw new ModelException("̐goodsquantity𐶐邱Ƃ͂ł܂");
		}
		this.value = value;
		logger.debug("OUT");
	}

	/**
	* Kquantityݒ肷邽߁AftHgRXgN^privateɂĂ܂B
	*/
	private GoodsQuantity() {
	}

	/**
	* _quantityvalueԂ܂B
	* @return quantity
	*/
	public double getValueAsDouble() {
		return this.value;
	}

	/**
	* quantityvalueԂ܂B
	* @return quantity
	*/
	public int getValueAsInt() {
		return (int) this.value;
	}

	/**
	* _IuWFNgquantityvalueԂ܂B
	* @return quantity
	*/
	public Double getValueAsDoubleObject() {
		return new Double(this.value);
	}

	/**
	* IuWFNgquantityvalueԂ܂B
	* @return quantity
	*/
	public Integer getValueAsIntegerObject() {
		return new Integer((int) this.value);
	}

	/**
	* GoodsQuantityƂ̔rȂ܂B
	* @param goodsquantity rtarget
	* @return ǂ̐^U
	*/
	public boolean equals(Object goodsquantity) {
		return this.value == ((GoodsQuantity) goodsquantity).value;
	}

	/**
	* ǂ炪r܂B
	* @param goodsquantity rtarget
	* @return r
	*/
	public int compareTo(Object goodsquantity) {
		logger.debug("IN");
		Double thisQuantity = new Double(value);
		Double targetquantity =
			new Double(((GoodsQuantity) goodsquantity).value);
		logger.debug("OUT");
		return thisQuantity.compareTo(targetquantity);
	}

	/**
	* goodsquantityɈGoodsQuantity𑫂GoodsQuantityԂ܂B
	* @param target Ztarget
	* @return Z
	*/
	public GoodsQuantity add(GoodsQuantity target) {
		logger.debug("IN");
		if (((GoodsQuantity) target).value < 0.0) {
			logger.debug("OUT(Exception)");
			throw new ModelException("Cannnot increase GoodsQuantity !");
		}
		logger.debug("OUT");
		return new GoodsQuantity(this.value + ((GoodsQuantity) target).value);
	}

	/**
	* ݂goodsquantityGoodsQuantityGoodsQuantityԂ܂B
	* Aremovequantity̕΁Aremove邱Ƃ͂łAModelExceptionԂ܂B
	* @param target Ztarget
	* @return Z
	*/
	public GoodsQuantity remove(GoodsQuantity target) {
		logger.debug("IN");
		if (this.value < ((GoodsQuantity) target).value) {
			throw new ModelException("Cannnot decrease GoodsQuantity !");
		}
		logger.debug("OUT");
		return new GoodsQuantity(this.value - ((GoodsQuantity) target).value);
	}

}
