/*
 * InformationManager.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.model.fmfw;

import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelException;

/**
 * G[WFg̎InformationǗ܂BiTOIɂ̓G[WFgɊ܂܂܂Bj
 * InformatioňInformationōs܂BɂATypeŌ邱Ƃ\łB
 * 
 * @author macchan
 * @version $Id: InformationManager.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class InformationManager
	implements java.io.Serializable{

	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(InformationManager.class.getName());

	/**
	* ftHgRXgN^łB
	*/
	protected InformationManager() {
		logger.debug("IN");
		this.informationMap = new HashMap();
		logger.debug("OUT");
	}

	private Map informationMap = new HashMap();

	/**
	 * Informationǉ܂BkeyInformationw肵ĂB
	 * @param key L[Information
	 * @param value lInformation
	 */
	public void putInformation(Information key, Information value) {
		informationMap.put(key, value);
	}

	/**
	 * InformationTypeƈvInformation(cloneł͂܂)Ԃ܂
	 * InformationȂꍇAExceptionԂ܂B
	 * @param key
	 * @return Information
	 */
	public Information getInformation(Information key){
		logger.debug("IN");
		if (!informationMap.containsKey(key)){
			logger.debug("OUT(Exception)");
			throw new ModelException("informaiton not found !");	
		}
	    logger.debug("OUT");
		return (Information) informationMap.get(key);

	}

	/**
	 * InformationTypeƈvInformation폜܂B
	 * InformationȂꍇAExceptionԂ܂B
	 * @param key
	 * @return Information 폜Information
	 */
	public Information removeInformation(Information key) {
		logger.debug("IN");
		if (!informationMap.containsKey(key)) {
			logger.debug("OUT(Exception)");
			throw new ModelException("Cannot found Information key :" + key);
		}
		logger.debug("OUT");
		return (Information) informationMap.remove(key);
	}

	/**
	 * IɊǗĂHashMapԂ܂B
	 * ̏Goods̕Aɂ̂ݎg܂B
	 * ̕ł͎gȂ悤ɂĂB
	 * @return HashMap i[ĂInformation
	 */
	public HashMap getInformations() {
		return new HashMap(informationMap);
	}
	
		/**
	* IɊǗĂHashMapݒ肵܂B
	* ̏Goods̕Aɂ̂ݎg܂B
	* ̕ł͎gȂ悤ɂĂB
	* @param map ݒ肷MAP
	*/
	public void setInformations(Map map) {
		this.informationMap = map;
	}
	//-------------------ȏAVR[h-------------------
}
