/*
 * RandomNumberGeneratorManager.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;

/**
 * @author macchan
 * @version $Id: RandomNumberGeneratorManager.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class RandomNumberGeneratorManager implements Serializable{

	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(RandomNumberGeneratorManager.class.getName());

	//worldŎgRandomNumberGeneratori[HashMapłBL[͗łB
	private Map randomNumberGeneratorMap = new HashMap();

	/**
	 * Constructor for RandomNumberGeneratorManager.
	 */
	protected RandomNumberGeneratorManager() {
		super();
	}

	/**
	* nameRandomNumberGeneratorĕԂ܂B
	* @param randomNumberGeneratorName RandomNumberGeneratorname
	* @return RandomNumberGeneratoriȂnullj
	*/
	public RandomNumberGenerator getRandomNumberGenerator(String name) {
		return (RandomNumberGenerator) randomNumberGeneratorMap.get(name);
	}

	/**
	* RandomNumberGeneratorrandomMapɒǉ܂B
	* AnameRandomNumberGeneratorɂ΁Aւ܂B
	* @param newRandomNumberGenerator addRandomNumberGenerator
	*/
	public void installRandomNumberGenerator(RandomNumberGenerator newRandomNumberGenerator) {
		logger.debug("IN");
		RandomNumberGenerator currentRandomNumberGenerator;
		if ((currentRandomNumberGenerator =
			this.getRandomNumberGenerator(
				newRandomNumberGenerator.getName()))
			!= null) {
			randomNumberGeneratorMap.remove(currentRandomNumberGenerator);
		}
		randomNumberGeneratorMap.put(
			newRandomNumberGenerator.getName(),
			newRandomNumberGenerator);
		logger.debug("OUT");
	}

}
