/*
 * ReceivedGoodsManager.java
 * Copyright (c) 2002 Boxed-Economy Project.  All rights reserved.
 */
package org.boxed_economy.besp.model.fmfw;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * ĂǗĂNX
 * @author macchan
 * @version $Id: ReceivedGoodsManager.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class ReceivedGoodsManager implements Serializable {

	private static final long serialVersionUID = 1L;

	private Behavior behavior = null;

	//map	
	private transient Map keptReceviedGoods = new HashMap();

	//current
	private transient ChannelEvent receivedEvent = null;
	private transient Goods receivedGoods = null;

	/**
	 * Constructor for ReceivedGoodsManager.
	 */
	protected ReceivedGoodsManager(Behavior behavior) {
		this.behavior = behavior;
	}

	public void setReceivedGoods(ChannelEvent event) {
		this.receivedEvent = event;
		if (this.keptReceviedGoods.containsKey(event)) {
			this.receivedGoods = (Goods) this.keptReceviedGoods.remove(event);
		} else {
			this.receivedGoods = event.getChannel().receiveGoods(this.behavior);
		}
	}

	public void keepReceivedGoods() {
		assert !this.keptReceviedGoods.containsKey(this.receivedEvent);
		this.keptReceviedGoods.put(this.receivedEvent, this.receivedGoods);
	}

	public Goods getReceivedGoods() {
		return this.receivedGoods;
	}

}
