/*
 * Relation.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.model.fmfw;

import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.fmfw.update.UpdateRelationEvent;

/**
 * Boxed EconomyɂagentԂ̐ÓIȊ֘A`܂B
 * ̎ނRelationTypeɂĒ`܂B
 * goods𑗂邽߂ɓIChannel𐶐邱Ƃł܂B
 * iꂽChannelRelationɕێ܂Bj
 * relation͕ArelationStartrelationEndagentێ܂B
 * 
 * @author macchan
 * @version $Id: Relation.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public final class Relation extends FmFwObject{

	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(Relation.class.getName());

	private RelationType type = null;
	private Agent source = null;
	private Agent target = null;
	private List channels = new ArrayList();

	/**
	 * RXgN^łB
	 * @param type RelationType
	 * @param source ֌WAgent
	 * @param target ֌WAgent
	 */
	protected Relation(RelationType type, Agent source, Agent target) {
		this.type = type;
		this.source = source;
		this.target = target;
	}

	/**
	* RelationTypeԂ܂B
	* @return RelationType
	*/
	public RelationType getType() {
		return type;
	}

	/**
	* relationĂagentԂ܂B
	* @return relationStart RelationAgent
	*/
	public Agent getSource() {
		return source;
	}

	/**
	* relationwĂagentԂ܂B
	* @return relationEnd RelationAgent
	*/
	public Agent getTarget() {
		return target;
	}

	/**
	 * ChannelJ݂邽߂̃\bhłBɊJ݂BehaviorƁAChannel
	 * ΏۂłBehaviorType^邱ƂŁAChannelJ݂鏈s܂B
	 * ̃\bhɂĊJ݂ꂽChannelBehaviorɕۑ܂B
	 * 
	 * @param openBehavior ChannelJ݂Behavior
	 * @param targetBehavior Channel̑ΏۂBehaviorType
	 * @return boolean J݂ł̐^U
	 */
	public boolean openChannel(
		Behavior openBehavior,
		BehaviorType targetBehaviorType) {
		return openChannel(openBehavior, targetBehaviorType, false);
	}

	/**
	 * ChannelJ݂邽߂̃\bhłBɊJ݂BehaviorƁAChannel
	 * ΏۂłBehaviorType^邱ƂŁAChannelJ݂鏈s܂B
	 * 
	 * @param openBehavior ChannelJ݂Behavior
	 * @param targetBehavior Channel̑ΏۂBehaviorType
	 * @param keepChannel J݂ꂽChannelۑ邩̐^U
	 * @return boolean J݂ł̐^U
	 */
	public boolean openChannel(
		Behavior openBehavior,
		BehaviorType targetBehaviorType,
		boolean keepChannel) {
		logger.debug("IN");
		OpenChannelEvent e = new OpenChannelEvent(this, targetBehaviorType);
		Behavior targetBehavior = target.receiveOpenChannelEvent(e);

		//ԂĂBehaviornullȂ΁AfalseԂ܂B
		if (targetBehavior == null) {
			logger.debug("OUT(false)");
			return false;
		}
		//ԂĂBehavir݂̂ŁAChannel𐶐āABehaviorꂼSet܂B
		Channel channel =
			new Channel(this, openBehavior, targetBehavior, keepChannel);
		openBehavior.setActiveChannel(channel);
		targetBehavior.setActiveChannel(channel);
		channels.add(channel);

		logger.debug("OUT(true)");
		fireChanneOpened(new UpdateRelationEvent(this, channel));
		return true;
	}

	/**
	 * Channel܂BChannelĂ΂܂B
	 * @param channel Channel
	 */
	protected void removeChannel(Channel channel) {
		logger.debug("IN");
		channels.remove(channel);
		fireChanneClosed(new UpdateRelationEvent(this, channel));
		logger.debug("OUT");
	}

	protected void fireChanneOpened(UpdateRelationEvent e) {
		if (source.getWorld().getPresentationContainer() != null) {
			source
				.getWorld()
				.getPresentationContainer()
				.getUpdateEventManager()
				.channelOpened(e);
		}
	}

	protected void fireChanneClosed(UpdateRelationEvent e) {
		if (source.getWorld().getPresentationContainer() != null) {
			source
				.getWorld()
				.getPresentationContainer()
				.getUpdateEventManager()
				.channelClosed(e);
		}
	}

	/*********************
	* for serializing
	********************/
	//	private void writeObject(ObjectOutputStream stream) throws IOException {
	//		stream.defaultWriteObject();
	//		stream.writeObject(this.getType().getName());
	//	}
	//
	//	private void readObject(ObjectInputStream stream)
	//		throws IOException, ClassNotFoundException {
	//		stream.defaultReadObject();
	//		String name = (String) stream.readObject();
	//		this.type = this.getSource().getWorld().getRelationType(name);
	//	}
}
