/*
 * RelationManager.java
 * 
 * Copyright (c) 2002 Boxed-Economy Project. All right reserved. 
 */
package org.boxed_economy.besp.model.fmfw;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;
import org.boxed_economy.besp.model.ModelException;
import org.boxed_economy.besp.model.fmfw.update.UpdateAgentEvent;

/**
 * G[WFg̎relationǗrelationManager`܂B
 * iTOIɂ̓G[WFgɊ܂܂܂Bj
 * relationTypeŒǉE폜EC^[tF[X܂B
 * RelationTypełقȂCX^XRelationʂĊi[܂B
 * 
 * @author macchan
 * @version $Id: RelationManager.java,v 1.1 2004/03/21 12:07:47 macchan Exp $
 */
public class RelationManager implements Serializable {

	private static final long serialVersionUID = 1L;
	private static final Logger logger =
		Logger.getLogger(RelationManager.class.getName());

	private Agent owner;
	private HashMap relationHashMap;

	protected RelationManager(Agent agent) {
		this.owner = agent;
		this.relationHashMap = new HashMap();
	}

	/**
	* Relationǉ܂B
	* TypeꍇAlistɓ܂
	* typeȂꍇAVlistāArelation܂
	* @param relation ǉRelation
	*/
	public void addRelation(Relation relation) {
		logger.debug("IN");
		//O`FbN
		if (!relation.getSource().equals(this.owner)) {
			throw new ModelException(
				"RelationstartAgentRelationManagerAgentƈvĂ܂"
					+ relation);
		}

		List list = (List) this.relationHashMap.get(relation.getType());
		//TypeꍇAlistɓ܂
		if (list != null) {
			//Srelation͈܂
			if (list.contains(relation))
				list.remove(relation);
			list.add(relation);
		}
		//typeȂꍇAVlistāArelation܂
		else {
			list = new ArrayList();
			list.add(relation);
			this.relationHashMap.put(relation.getType(), list);
		}
		logger.debug("OUT");
	}

	/**
	 * Relation폜܂B
	 * type܂܂ȂꍇlistɊ܂܂ȂꍇException𓊂܂
	 * @param relation 폜ΏۂRelation
	 */
	public void removeRelation(Relation relation) {
		logger.debug("IN");
		List list = (List) this.relationHashMap.get(relation.getType());
		if (list != null) {
			if (list.contains(relation)) {
				list.remove(relation);
				//listɂȂꍇlist폜܂
				if (list == null || list.isEmpty()) {
					this.relationHashMap.remove(relation.getType());
				}
			}
			//listɊ܂܂ȂꍇException𓊂܂		
			else {
				throw new ModelException("Relation not found ! " + relation);
			}
		}
		//type܂܂ȂꍇException𓊂܂
		else {
			logger.debug("OUT(Exception)");
			throw new ModelException("Relation not found ! " + relation);
		}
		logger.debug("OUT");
	}

	/**
	 * TypeRelationSĂ폜܂B
	 * TypeȂꍇException𓊂܂
	 * @param type 폜ΏۂType
	 */
	public Collection removeRelations(RelationType type) {
		logger.debug("IN");
		List list = (List) this.relationHashMap.get(type);
		if (list != null) {
			for (Iterator i = list.iterator(); i.hasNext();) {
				Relation relation = (Relation) i.next();
				i.remove();
				owner.fireRelationRemoved(
					new UpdateAgentEvent(owner, relation));
			}
			this.relationHashMap.remove(type);
		}
		//TypeȂꍇException𓊂܂
		else {
			logger.debug("OUT(Exception)");
			throw new ModelException("RelationType not found ! " + type);
		}
		logger.debug("OUT");
		return list;
	}

	/**
	 * AgentւRelation폜܂B
	 * Agent̍폜ɁAAgentĂ΂܂B
	 * @param agent 폜ΏۂRelation̐Agent
	 */
	public void removeRelationsByAgent(Agent agent) {
		logger.debug("IN");
		//Relation܂Ƃ߂܂B
		List list = new ArrayList();
		Iterator i = relationHashMap.keySet().iterator();
		while (i.hasNext()) {
			RelationType rType = (RelationType) i.next();
			list.addAll(getRelations(rType));
		}

		//܂Ƃ߂ꂽListԂɒTA폜Xg쐬
		List removeList = new ArrayList();
		Iterator j = list.iterator();
		while (j.hasNext()) {
			Relation relation = (Relation) j.next();
			if (agent.equals(relation.getTarget())) {
				removeList.add(relation);
			}
		}

		//폜Xg珇Ԃɍ폜܂B
		Iterator k = removeList.iterator();
		while (k.hasNext()) {
			Relation relation = (Relation) k.next();
			removeRelation(relation);
			//Event sǉ
			owner.fireRelationRemoved(new UpdateAgentEvent(owner, relation));
		}
		logger.debug("OUT");
	}

	/**
	 * Typeyт̎qTypeRelationSĂ폜܂B
	 * @param type 폜ΏۂType
	 */
	public Collection removeRelationsRecursively(RelationType type) {
		logger.debug("IN");
		List value = (List) this.removeRelations(type);
		if (value != null) {
			Iterator i = type.getChildrenRecursively().iterator();
			while (i.hasNext()) {
				RelationType t = (RelationType) i.next();
				value.addAll(this.removeRelations(t));
			}
		} else {
			logger.debug("OUT(Exception)");
			throw new ModelException("RelationType not found ! " + type);
		}

		logger.debug("OUT");
		return value;
	}

	/**
	 * RelaitonManager̎RelationTypeԂ܂B
	 * A݂ȂException܂B
	 * @return Collection Relation̎TypẽXg
	 */
	public Collection getRelationTypes() {

		return new HashSet(this.relationHashMap.keySet());
	}

	/**
	 * TypełRelationԂ܂BiꍇAŏRelationԂ܂Bj
	 * A݂ȂException܂B
	 * @param type ΏۂType
	 * @return Relation YRelation
	 */
	public Relation getRelation(RelationType type) {
		return (Relation) ((List) this.getRelations(type)).get(0);
	}

	/**
	 * TypeA֌W悪AgentłRelationԂ܂
	 * ݂ȂꍇAException𓊂܂
	 */
	public Relation getRelation(RelationType type, Agent agent) {
		Relation returnRelation = null;
		Iterator ite = ((List) this.getRelations(type)).iterator();
		while (ite.hasNext()) {
			Relation relation = (Relation) ite.next();
			//agentƊ֌WagentvꍇɁÅ֌WԂlɓ܂
			if (relation.getTarget().equals(agent)) {
				returnRelation = relation;
			}
		}

		//ԂRelationExceptionł
		if (returnRelation == null) {
			throw new ModelException("Not relation exists. " + this);
		}
		return returnRelation;
	}

	/**
	 * TypełrelationXgƂđSĕԂ܂B
	 * A݂ȂA邢͋łꍇ͋̃XgԂ܂B
	 * @param type ΏۂType
	 * @return Collection YRelatioñXg
	 */
	public Collection getRelations(RelationType type) {
		logger.debug("IN");
		List value = (List) this.relationHashMap.get(type);
		if (value == null || value.isEmpty()) {
			logger.debug("OUT(Exception)");
			return new ArrayList();
		}
		logger.debug("OUT");
		return new ArrayList(value);
	}

	/**
	 * TypeyтType̎qTypełSĂrelationԂ܂B
	 * A݂Ȃ΋̃XgԂ܂B
	 * @param type ΏۂType
	 * @return Collection YRelatioñXg
	 */
	public Collection getRelationsRecursively(RelationType type) {
		logger.debug("IN");
		Collection value = (List) this.getRelations(type);
		if (value != null) {
			Iterator i = type.getChildrenRecursively().iterator();
			while (i.hasNext()) {
				RelationType t = (RelationType) i.next();
				value.addAll(this.getRelations(t));
			}
			logger.debug("OUT");
			return new ArrayList(value);
		} else {
			logger.debug("OUT(Exception)");
			return new ArrayList();
		}
	}

	/**
	 * Method getAllRelations.
	 * @return
	 */
	public List getAllRelations() {
		List relations = new ArrayList();
		Collection behaviorsLists = this.relationHashMap.values();
		for (Iterator i = behaviorsLists.iterator(); i.hasNext();) {
			List relationsList = (List) i.next();
			for (Iterator j = relationsList.iterator(); j.hasNext();) {
				Relation element = (Relation) j.next();
				relations.add(element);
			}
		}
		return relations;
	}

	//--------------------------狌R[h-----------------------------
}
